/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.internal.rmi;

import java.io.File;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.rmi.NotBoundException;
import java.rmi.ServerError;
import java.rmi.ServerException;
import java.rmi.registry.LocateRegistry;
import java.util.concurrent.ExecutionException;
import org.geotoolkit.internal.rmi.LocalExecutor;
import org.geotoolkit.internal.rmi.LocalFuture;
import org.geotoolkit.internal.rmi.RemoteService;
import org.geotoolkit.internal.rmi.ShareableTask;
import org.geotoolkit.internal.rmi.TaskExecutor;
import org.geotoolkit.lang.Static;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Utilities;

public final class RMI
extends Static {
    private static String master;
    private static TaskExecutor executor;
    private static volatile File sharedTemporaryDirectory;

    private RMI() {
    }

    public static synchronized void setMaster(String string) {
        if (!Utilities.equals(string, master)) {
            master = string;
            executor = null;
        }
    }

    public static void setSharedTemporaryDirectory(File file) {
        if (file != null && !file.isDirectory()) {
            throw new IllegalArgumentException(Errors.format(143, file));
        }
        sharedTemporaryDirectory = file;
    }

    public static File getSharedTemporaryDirectory() {
        File file = sharedTemporaryDirectory;
        if (file == null && !(file = new File(System.getProperty("java.io.tmpdir", "/tmp"), "Geotoolkit.org")).isDirectory() && !file.mkdir()) {
            file = file.getParentFile();
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <Output> Output execute(ShareableTask<?, Output> shareableTask) throws IOException {
        Object object = RMI.class;
        synchronized (RMI.class) {
            TaskExecutor taskExecutor = executor;
            if (taskExecutor == null) {
                if (master == null) {
                    taskExecutor = new LocalExecutor(false);
                } else {
                    try {
                        taskExecutor = (TaskExecutor)LocateRegistry.getRegistry(master).lookup("org/geotoolkit/RemoteExecutor");
                    }
                    catch (NotBoundException notBoundException) {
                        RemoteService.logger().warning(notBoundException.toString());
                        taskExecutor = new LocalExecutor(false);
                    }
                }
                executor = taskExecutor;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            object = taskExecutor.submit(shareableTask);
            boolean bl = false;
            try {
                Object Output = object.get();
                bl = true;
                Object Output2 = Output;
                return Output2;
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (object instanceof LocalFuture && !((LocalFuture)object).isThreaded() && throwable instanceof IOException) {
                    throw (IOException)throwable;
                }
                String string = executionException.getLocalizedMessage();
                if (throwable instanceof Exception) {
                    throw new ServerException(string, (Exception)throwable);
                }
                if (throwable instanceof Error) {
                    throw new ServerError(string, (Error)throwable);
                }
                throw new ServerException(string, executionException);
            }
            catch (InterruptedException interruptedException) {
                InterruptedIOException interruptedIOException = new InterruptedIOException(interruptedException.getLocalizedMessage());
                interruptedIOException.initCause(interruptedException);
                throw interruptedIOException;
            }
            finally {
                if (!bl) {
                    object.rollback();
                }
            }
        }
    }
}

