/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.metadata;

import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import org.geotoolkit.metadata.KeyNamePolicy;
import org.geotoolkit.metadata.MetadataMap;
import org.geotoolkit.metadata.PropertyAccessor;

final class NameMap
extends MetadataMap<String> {
    final KeyNamePolicy valueNames;

    NameMap(PropertyAccessor propertyAccessor, KeyNamePolicy keyNamePolicy, KeyNamePolicy keyNamePolicy2) {
        super(propertyAccessor, keyNamePolicy2);
        this.valueNames = keyNamePolicy;
    }

    @Override
    public int size() {
        return this.accessor.count();
    }

    @Override
    public boolean containsKey(Object object) {
        return object instanceof String && this.accessor.indexOf((String)object) >= 0;
    }

    @Override
    public String get(Object object) {
        int n;
        if (object instanceof String && (n = this.accessor.indexOf((String)object)) >= 0) {
            return this.accessor.name(n, this.valueNames);
        }
        return null;
    }

    @Override
    final Iterator<Map.Entry<String, String>> iterator() {
        return new Iter();
    }

    private final class Iter
    extends MetadataMap.Iter {
        private int next;

        Iter() {
            super(NameMap.this);
        }

        @Override
        public boolean hasNext() {
            return this.next < NameMap.this.accessor.count();
        }

        @Override
        public Map.Entry<String, String> next() {
            int n;
            PropertyAccessor propertyAccessor = NameMap.this.accessor;
            if ((n = this.next++) >= propertyAccessor.count()) {
                throw new NoSuchElementException();
            }
            return new AbstractMap.SimpleEntry<String, String>(propertyAccessor.name(n, NameMap.this.keyNames), propertyAccessor.name(n, NameMap.this.valueNames));
        }
    }
}

