/*
 * Decompiled with CFR 0.152.
 */
package com.galdosinc.glib.gml.schema.xpsvi;

import com.galdosinc.glib.gml.schema.GmlPropertyDefinition;
import com.galdosinc.glib.gml.schema.GmlSchemaParser;
import java.util.LinkedList;
import java.util.List;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;

public class XPsviGmlPropertyDefinition
implements GmlPropertyDefinition {
    private GmlSchemaParser model;
    private XSParticle particle;
    private XSElementDeclaration element;
    private List geometryTypeNames_;
    private List topologyTypeNames_;
    private XSTypeDefinition type;

    public XPsviGmlPropertyDefinition(GmlSchemaParser model, XSParticle particle) {
        this.model = model;
        this.particle = particle;
        XSTerm term = particle.getTerm();
        if (!(term instanceof XSElementDeclaration)) {
            throw new IllegalArgumentException("A property can only be created from an element particle");
        }
        this.element = (XSElementDeclaration)term;
        this.type = this.element.getTypeDefinition();
    }

    @Override
    public String getNamespaceUri() {
        return this.element.getNamespace();
    }

    @Override
    public String getName() {
        return this.element.getName();
    }

    @Override
    public int getMinOccurs() {
        return this.particle.getMinOccurs();
    }

    @Override
    public int getMaxOccurs() {
        return this.particle.getMaxOccurs();
    }

    @Override
    public boolean isMandatory() {
        return this.getMinOccurs() > 0;
    }

    @Override
    public boolean isGeometryProperty() {
        List geometryTypeNames = this.getGeometryTypeNames();
        return geometryTypeNames != null;
    }

    @Override
    public boolean isTopologyProperty() {
        List topologyTypeNames = this.getTopologyTypeNames();
        return topologyTypeNames != null;
    }

    @Override
    public boolean isSimpleValued() {
        if (this.type.getTypeCategory() == 14) {
            return true;
        }
        if (this.type.getTypeCategory() == 13) {
            short contentType = ((XSComplexTypeDefinition)this.type).getContentType();
            return contentType == 1;
        }
        return false;
    }

    @Override
    public boolean canHaveRemoteValue() {
        if (this.type.getTypeCategory() == 14) {
            return true;
        }
        XSComplexTypeDecl complexType = (XSComplexTypeDecl)this.type;
        XSAttributeGroupDecl attributeGroupDefinition = complexType.getAttrGrp();
        if (attributeGroupDefinition == null) {
            return false;
        }
        XSObjectList attrUses = attributeGroupDefinition.getAttributeUses();
        for (int ii = 0; ii < attrUses.getLength(); ++ii) {
            XSAttributeUse attrUse = (XSAttributeUse)attrUses.item(ii);
            XSAttributeDeclaration attrDecl = attrUse.getAttrDeclaration();
            if (!attrDecl.getName().equals("href") || attrDecl.getNamespace() == null || !attrDecl.getNamespace().equals("http://www.w3.org/1999/xlink")) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean canHaveLocalValue() {
        return this.element.getEnclosingCTDefinition().getContentType() != 0;
    }

    @Override
    public List getGeometryTypeNames() {
        if (this.geometryTypeNames_ != null) {
            return this.geometryTypeNames_;
        }
        this.geometryTypeNames_ = new LinkedList();
        if (this.model.getGeometryTypesFromGeometryProperty(this.element, this.geometryTypeNames_)) {
            return this.geometryTypeNames_;
        }
        return null;
    }

    @Override
    public List getTopologyTypeNames() {
        if (this.topologyTypeNames_ != null) {
            return this.topologyTypeNames_;
        }
        this.topologyTypeNames_ = new LinkedList();
        if (this.model.getTopologyTypesFromTopologyProperty(this.element, this.topologyTypeNames_)) {
            return this.topologyTypeNames_;
        }
        return null;
    }

    @Override
    public boolean isFeatureArrayProperty() {
        return this.model.isFeatureArrayProperty(this.element.getNamespace(), this.element.getName());
    }

    @Override
    public boolean isFeatureValueProperty() {
        return this.model.isFeatureMember(this.element.getNamespace(), this.element.getName()) || this.model.isFeatureArrayProperty(this.element.getNamespace(), this.element.getName());
    }
}

