/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.geometry.jts.JTSEnvelope2D;
import org.geotoolkit.gml.GeometrytoJTS;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.xml.MarshallerPool;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.geometry.DirectPosition;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.FactoryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Extents {
    private static final String GML_NS = "http://www.opengis.net/gml/3.2";
    private static final GeometryFactory JTS_GEOM_FACTORY = new GeometryFactory();

    private Extents() {
    }

    public static org.opengis.geometry.Envelope calculateEnvelope(NodeList geomNodes) throws JAXBException {
        Unmarshaller unmarshaller = null;
        try {
            MarshallerPool pool = new MarshallerPool("org.geotoolkit.gml.xml.v321");
            unmarshaller = pool.acquireUnmarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        Envelope envelope = new Envelope();
        CoordinateReferenceSystem crs = null;
        for (int i = 0; i < geomNodes.getLength(); ++i) {
            Geometry jtsGeom;
            Node node = geomNodes.item(i);
            JAXBElement result = (JAXBElement)unmarshaller.unmarshal(node);
            AbstractGeometry gmlGeom = (AbstractGeometry)result.getValue();
            crs = gmlGeom.getCoordinateReferenceSystem();
            try {
                jtsGeom = GeometrytoJTS.toJTS((AbstractGeometry)gmlGeom);
            }
            catch (FactoryException e) {
                throw new RuntimeException(e);
            }
            envelope.expandToInclude(jtsGeom.getEnvelopeInternal());
        }
        return new JTSEnvelope2D(envelope, crs);
    }

    public static Document envelopeAsGML(org.opengis.geometry.Envelope envelope) {
        Document doc;
        try {
            doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
        Element gmlEnv = doc.createElementNS(GML_NS, "gml:Envelope");
        doc.appendChild(gmlEnv);
        gmlEnv.setAttribute("srsName", GeodesyUtils.getCRSIdentifier(envelope.getCoordinateReferenceSystem()));
        DecimalFormat df = new DecimalFormat("#.##");
        df.setRoundingMode(RoundingMode.DOWN);
        StringBuffer lowerCoord = new StringBuffer();
        StringBuffer upperCoord = new StringBuffer();
        for (int i = 0; i < envelope.getDimension(); ++i) {
            lowerCoord.append(df.format(envelope.getMinimum(i)));
            upperCoord.append(df.format(envelope.getMaximum(i)));
            if (i >= envelope.getDimension() - 1) continue;
            lowerCoord.append(' ');
            upperCoord.append(' ');
        }
        Element lowerCorner = doc.createElementNS(GML_NS, "gml:lowerCorner");
        lowerCorner.setTextContent(lowerCoord.toString());
        gmlEnv.appendChild(lowerCorner);
        Element upperCorner = doc.createElementNS(GML_NS, "gml:upperCorner");
        upperCorner.setTextContent(upperCoord.toString());
        gmlEnv.appendChild(upperCorner);
        return doc;
    }

    public static Polygon envelopeAsPolygon(org.opengis.geometry.Envelope envelope) {
        DirectPosition lowerCorner = envelope.getLowerCorner();
        DirectPosition upperCorner = envelope.getUpperCorner();
        LinearRing ring = JTS_GEOM_FACTORY.createLinearRing(new Coordinate[]{new Coordinate(lowerCorner.getOrdinate(0), lowerCorner.getOrdinate(1)), new Coordinate(upperCorner.getOrdinate(0), lowerCorner.getOrdinate(1)), new Coordinate(upperCorner.getOrdinate(0), upperCorner.getOrdinate(1)), new Coordinate(lowerCorner.getOrdinate(0), upperCorner.getOrdinate(1)), new Coordinate(lowerCorner.getOrdinate(0), lowerCorner.getOrdinate(1))});
        Polygon polygon = JTS_GEOM_FACTORY.createPolygon(ring);
        JTS.setCRS((Geometry)polygon, (CoordinateReferenceSystem)envelope.getCoordinateReferenceSystem());
        return polygon;
    }
}

