/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.level1;

import java.lang.reflect.Constructor;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.dom.ElementOverNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.kml22.BaseFixture;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UserDefinedDataTests
extends BaseFixture {
    static final Set<QName> SIMPLE_FIELD_TYPES;
    static final Map<QName, Class<?>> XSD_JAVA_MAPPINGS;

    @Test(description="Implements ATC 25")
    public void schemaHasIdAttribute() {
        NodeList schemaNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Schema");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < schemaNodes.getLength(); ++i) {
            Element schema = (Element)schemaNodes.item(i);
            if (!schema.getAttribute("id").isEmpty()) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.Schema.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(schema)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 26")
    public void verifySimpleField() {
        NodeList simpleFieldNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "SimpleField");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < simpleFieldNodes.getLength(); ++i) {
            QName fieldType;
            Element field = (Element)simpleFieldNodes.item(i);
            if (field.getAttribute("name").isEmpty()) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.SchemaSimpleField.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(field)));
            }
            if (SIMPLE_FIELD_TYPES.contains(fieldType = this.getFieldType(field))) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.SchemaSimpleField.err2", field.getAttribute("name")), new ErrorLocator(-1, -1, XMLUtils.getXPointer(field)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 27")
    public void verifySchemaData() {
        NodeList schemaDataNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "SchemaData");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < schemaDataNodes.getLength(); ++i) {
            Element schemaData = (Element)schemaDataNodes.item(i);
            String schemaUrl = schemaData.getAttribute("schemaUrl");
            if (schemaUrl.isEmpty()) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.ExtendedDataSchemaData.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(schemaData)));
                continue;
            }
            URI schemaURI = URI.create(schemaUrl);
            String xpath = null;
            if (null == schemaURI.getScheme()) {
                xpath = String.format("//kml:Schema[@id='%s']", schemaURI.getFragment());
            } else {
                int numSign = schemaURI.toString().indexOf(35);
                xpath = String.format("doc('%s')//kml:Schema[@id='%s']", schemaURI.toString().substring(0, numSign), schemaURI.getFragment());
            }
            DOMSource src = new DOMSource(this.testSubject, this.testSubject.getBaseURI());
            XdmValue result = null;
            try {
                result = XMLUtils.evaluateXPath2(src, xpath, NS_MAP);
            }
            catch (SaxonApiException sae) {
                TestSuiteLogger.log(Level.WARNING, "Failed to evaluate XPath expression", (Exception)((Object)sae));
            }
            if (null == result || result.size() == 0) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.ExtendedDataSchemaData.err3", xpath), new ErrorLocator(-1, -1, XMLUtils.getXPointer(schemaData)));
                continue;
            }
            this.checkSimpleDataElements(schemaData, (XdmNode)result.itemAt(0), errHandler);
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 28")
    public void verifyUntypedDataAreUnique() throws XPathExpressionException {
        NodeList extData = XMLUtils.evaluateXPath(this.testSubject, "//kml:ExtendedData[kml:Data]", NS_MAP);
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        HashSet<String> nameSet = new HashSet<String>();
        for (int i = 0; i < extData.getLength(); ++i) {
            nameSet.clear();
            NodeList names = XMLUtils.evaluateXPath(extData.item(i), "kml:Data/@name", NS_MAP);
            for (int j = 0; j < names.getLength(); ++j) {
                Node nameAttr = names.item(j);
                if (nameSet.add(nameAttr.getTextContent())) continue;
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.ExtendedDataData.err", nameAttr.getTextContent()), new ErrorLocator(-1, -1, XMLUtils.getXPointer(extData.item(i))));
            }
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    void checkSimpleDataElements(Element schemaData, XdmNode schemaNode, ValidationErrorHandler errHandler) {
        String name;
        int i;
        NodeList simpleDataNodes = schemaData.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "SimpleData");
        Element schema = (Element)ElementOverNodeInfo.wrap((NodeInfo)schemaNode.getUnderlyingNode());
        HashMap<String, QName> schemaMap = new HashMap<String, QName>();
        NodeList simpleFieldNodes = schema.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "SimpleField");
        for (i = 0; i < simpleFieldNodes.getLength(); ++i) {
            Element simpleField = (Element)simpleFieldNodes.item(i);
            name = simpleField.getAttribute("name");
            schemaMap.put(name, this.getFieldType(simpleField));
        }
        for (i = 0; i < simpleDataNodes.getLength(); ++i) {
            QName dataType;
            Element simpleData = (Element)simpleDataNodes.item(i);
            name = simpleData.getAttribute("name");
            if (!schemaMap.containsKey(name)) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.ExtendedDataSchemaData.err4", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(simpleData)));
                continue;
            }
            String value = simpleData.getTextContent().trim();
            if (this.valueConformsToType(value, dataType = (QName)schemaMap.get(name))) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.ExtendedDataSchemaData.err5", String.format("Value '%s' does not conform to the type %s", value, dataType)), new ErrorLocator(-1, -1, XMLUtils.getXPointer(simpleData)));
        }
    }

    boolean valueConformsToType(String value, QName dataType) {
        Class<?> type = XSD_JAVA_MAPPINGS.get(dataType);
        if (null == type) {
            return false;
        }
        Object obj = null;
        try {
            Constructor<?> ctor = type.getConstructor(String.class);
            obj = ctor.newInstance(value);
        }
        catch (Exception e) {
            // empty catch block
        }
        return null != obj;
    }

    QName getFieldType(Element field) {
        QName fieldType;
        String fieldTypeVal = field.getAttribute("type");
        if (fieldTypeVal.contains(":")) {
            String[] qName = fieldTypeVal.split(":");
            fieldType = new QName(field.lookupNamespaceURI(qName[0]), qName[1], qName[0]);
        } else {
            fieldType = new QName("http://www.w3.org/2001/XMLSchema", fieldTypeVal);
        }
        return fieldType;
    }

    static {
        HashSet<QName> types = new HashSet<QName>();
        types.add(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"));
        types.add(new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd"));
        types.add(new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt", "xsd"));
        types.add(new QName("http://www.w3.org/2001/XMLSchema", "short", "xsd"));
        types.add(new QName("http://www.w3.org/2001/XMLSchema", "unsignedShort", "xsd"));
        types.add(new QName("http://www.w3.org/2001/XMLSchema", "float", "xsd"));
        types.add(new QName("http://www.w3.org/2001/XMLSchema", "double", "xsd"));
        types.add(new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xsd"));
        SIMPLE_FIELD_TYPES = Collections.unmodifiableSet(types);
        HashMap<QName, Class> mappings = new HashMap<QName, Class>();
        mappings.put(new QName("http://www.w3.org/2001/XMLSchema", "string", "xsd"), String.class);
        mappings.put(new QName("http://www.w3.org/2001/XMLSchema", "int", "xsd"), Integer.class);
        mappings.put(new QName("http://www.w3.org/2001/XMLSchema", "unsignedInt", "xsd"), Long.class);
        mappings.put(new QName("http://www.w3.org/2001/XMLSchema", "short", "xsd"), Short.class);
        mappings.put(new QName("http://www.w3.org/2001/XMLSchema", "unsignedShort", "xsd"), Integer.class);
        mappings.put(new QName("http://www.w3.org/2001/XMLSchema", "float", "xsd"), Float.class);
        mappings.put(new QName("http://www.w3.org/2001/XMLSchema", "double", "xsd"), Double.class);
        mappings.put(new QName("http://www.w3.org/2001/XMLSchema", "boolean", "xsd"), Boolean.class);
        XSD_JAVA_MAPPINGS = Collections.unmodifiableMap(mappings);
    }
}

