/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import javax.xml.soap.SOAPException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class BasicCapabilitiesTests
extends BaseFixture {
    static final String BASIC_WFS_PHASE = "BasicWFSPhase";
    private static final String SCHEMATRON_METADATA = "wfs-capabilities-2.0.sch";

    @BeforeTest
    public void implementsBasicWFS(ITestContext testContext) {
        this.wfsMetadata = (Document)testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        String xpath = String.format("//ows:Constraint[@name='%s']/ows:DefaultValue = 'TRUE'", "ImplementsBasicWFS");
        ETSAssert.assertXPath(xpath, this.wfsMetadata, null);
    }

    @BeforeClass
    public void buildGetCapabilitiesRequest() {
        this.reqEntity = this.docBuilder.newDocument();
        Element docElem = this.reqEntity.createElementNS("http://www.opengis.net/wfs/2.0", "GetCapabilities");
        docElem.setAttribute("service", "WFS");
        this.reqEntity.appendChild(docElem);
    }

    @Test(description="See ISO 19142: Table 1, Table 13, A.1.2", dataProvider="protocol-binding")
    public void wfsCapabilitiesDescribesBasicWFS(ProtocolBinding binding) throws SOAPException {
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetCapabilities", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        Document entity = this.extractBodyAsDocument(rsp, binding);
        SchematronValidator validator = ValidationUtils.buildSchematronValidator(SCHEMATRON_METADATA, BASIC_WFS_PHASE);
        DOMResult result = validator.validate((Source)new DOMSource(entity, entity.getDocumentURI()));
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }
}

