/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter;

import com.sun.jersey.api.client.ClientResponse;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PropertyIsEqualToOperatorTests
extends QueryFilterFixture {
    private static String MATCH_ALL = "All";
    private static String MATCH_ANY = "Any";

    @Test(description="See ISO 19143: 7.7.3.2", dataProvider="protocol-featureType")
    public void propertyIsEqualTo_caseSensitive(ProtocolBinding binding, QName featureType) {
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        Map<XSElementDeclaration, String> propValueMap = this.findMatchingPropertyValue(featureType);
        if (propValueMap.isEmpty()) {
            throw new SkipException("No simple property values found for feature type " + featureType);
        }
        Map.Entry<XSElementDeclaration, String> propValue = propValueMap.entrySet().iterator().next();
        XSElementDeclaration propDecl = propValue.getKey();
        QName propName = new QName(propDecl.getNamespace(), propDecl.getName());
        this.addPropertyIsEqualToPredicate(this.reqEntity, propName, propValue.getValue(), true, null, false);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        NodeList features = this.rspEntity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        QName dataType = AppSchemaUtils.getBuiltInDatatype(propDecl);
        String propTypeName = dataType.getLocalPart();
        String xpath = String.format("xs:%s(ns1:%s[1]) = xs:%s('%s')", propTypeName, propName.getLocalPart(), propTypeName, propValue.getValue());
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(propName.getNamespaceURI(), "ns1");
        for (int i = 0; i < features.getLength(); ++i) {
            ETSAssert.assertXPath2(xpath, new DOMSource(features.item(i)), nsBindings);
        }
    }

    @Test(description="See ISO 19143: 7.7.3.2", dataProvider="protocol-featureType")
    public void propertyIsNotEqualTo_caseSensitive(ProtocolBinding binding, QName featureType) {
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        Map<XSElementDeclaration, String> propValueMap = this.findMatchingPropertyValue(featureType);
        if (propValueMap.isEmpty()) {
            throw new SkipException("No simple property values found for feature type " + featureType);
        }
        Map.Entry<XSElementDeclaration, String> propValue = propValueMap.entrySet().iterator().next();
        XSElementDeclaration propDecl = propValue.getKey();
        QName propName = new QName(propDecl.getNamespace(), propDecl.getName());
        this.addPropertyIsEqualToPredicate(this.reqEntity, propName, propValue.getValue(), true, MATCH_ALL, true);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        NodeList features = this.rspEntity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        QName dataType = AppSchemaUtils.getBuiltInDatatype(propDecl);
        String propTypeName = dataType.getLocalPart();
        String xpath = String.format("not(xs:%s(ns1:%s[1]) = xs:%s('%s'))", propTypeName, propName.getLocalPart(), propTypeName, propValue.getValue());
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(propName.getNamespaceURI(), "ns1");
        for (int i = 0; i < features.getLength(); ++i) {
            ETSAssert.assertXPath2(xpath, new DOMSource(features.item(i)), nsBindings);
        }
    }

    void addPropertyIsEqualToPredicate(Document request, QName propertyName, String value, boolean matchCase, String matchAction, boolean negate) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        if (null == propertyName) {
            throw new IllegalArgumentException("propertyName is required.");
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
        queryElem.appendChild(filter);
        Element predicate = negate ? request.createElementNS("http://www.opengis.net/fes/2.0", "PropertyIsNotEqualTo") : request.createElementNS("http://www.opengis.net/fes/2.0", "PropertyIsEqualTo");
        filter.appendChild(predicate);
        String matchActionAttr = null != matchAction && !matchAction.isEmpty() ? matchAction : MATCH_ANY;
        predicate.setAttribute("matchCase", Boolean.toString(matchCase));
        predicate.setAttribute("matchAction", matchActionAttr);
        Element literal = request.createElementNS("http://www.opengis.net/fes/2.0", "Literal");
        literal.setTextContent(value);
        predicate.appendChild(literal);
        Element valueRef = request.createElementNS("http://www.opengis.net/fes/2.0", "ValueReference");
        predicate.appendChild(valueRef);
        String prefix = propertyName.getPrefix().length() > 0 ? propertyName.getPrefix() : "tns";
        String nsURI = request.lookupNamespaceURI(prefix);
        if (null == nsURI) {
            valueRef.setAttribute("xmlns:" + prefix, propertyName.getNamespaceURI());
        }
        valueRef.setTextContent(prefix + ":" + propertyName.getLocalPart());
    }

    Map<XSElementDeclaration, String> findMatchingPropertyValue(QName featureType) {
        XSTypeDefinition xsdSimpleType = this.model.getTypeDefinition("anySimpleType", "http://www.w3.org/2001/XMLSchema");
        List<XSElementDeclaration> simpleProps = AppSchemaUtils.getFeaturePropertiesByType(this.model, featureType, xsdSimpleType);
        ListIterator<XSElementDeclaration> listItr = simpleProps.listIterator(simpleProps.size());
        XSElementDeclaration prop = null;
        String propValue = null;
        while (listItr.hasPrevious()) {
            prop = listItr.previous();
            QName propName = new QName(prop.getNamespace(), prop.getName());
            List<String> values = this.dataSampler.getSimplePropertyValues(featureType, propName, null);
            if (values.isEmpty()) continue;
            propValue = values.get(0);
            break;
        }
        HashMap<XSElementDeclaration, String> map = new HashMap<XSElementDeclaration, String>();
        if (null != propValue) {
            map.put(prop, propValue);
        }
        return map;
    }
}

