/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.simple;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ConformanceClass;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StoredQueryTests
extends BaseFixture {
    private String featureId;
    private Schema wfsSchema;

    @BeforeClass
    @Parameters(value={"fid"})
    public void initClassFixture(String fid, ITestContext testContext) {
        this.featureId = fid;
        this.wfsSchema = (Schema)testContext.getSuite().getAttribute(SuiteAttribute.WFS_SCHEMA.getName());
        Assert.assertNotNull((Object)this.wfsSchema, (String)"WFS schema not found in suite fixture.");
    }

    @BeforeMethod
    public void buildGetFeatureRequestEntity() {
        this.reqEntity = WFSRequest.createRequestEntity("GetFeature");
    }

    @Test(description="See ISO 19142: 7.9.3.4", dataProvider="protocol-binding")
    public void unknownStoredQuery(ProtocolBinding binding) {
        WFSRequest.appendStoredQuery(this.reqEntity, "http://docbook.org/ns/docbook", Collections.emptyMap());
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        SchematronValidator validator = ValidationUtils.buildSchematronValidator("ExceptionReport.sch", "InvalidParameterValuePhase");
        DOMResult result = validator.validate((Source)new DOMSource(this.rspEntity));
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }

    @Test(description="See ISO 19142: 7.9.3.6, 11.4", dataProvider="protocol-binding")
    public void invokeGetFeatureByIdWithUnknownID(ProtocolBinding binding) {
        String id = "uuid-" + UUID.randomUUID().toString();
        WFSRequest.appendStoredQuery(this.reqEntity, "urn:ogc:def:query:OGC-WFS::GetFeatureById", Collections.singletonMap("id", id));
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        int statusCode = rsp.getStatus();
        Assert.assertTrue((statusCode == ClientResponse.Status.NOT_FOUND.getStatusCode() || statusCode == ClientResponse.Status.FORBIDDEN.getStatusCode() ? 1 : 0) != 0, (String)("Expected status code 403 or 404. Received: " + statusCode));
    }

    @Test(description="See ISO 19142: 7.9.3.6", dataProvider="protocol-binding")
    public void invokeGetFeatureById(ProtocolBinding binding) {
        if (null == this.featureId || this.featureId.isEmpty()) {
            this.featureId = this.findFeatureIdentifier(this.wfsMetadata);
        }
        Assert.assertFalse((null == this.featureId || this.featureId.isEmpty() ? 1 : 0) != 0, (String)ErrorMessage.get("FidNotFound"));
        WFSRequest.appendStoredQuery(this.reqEntity, "urn:ogc:def:query:OGC-WFS::GetFeatureById", Collections.singletonMap("id", this.featureId));
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        Element feature = this.rspEntity.getDocumentElement();
        Assert.assertEquals((String)feature.getAttributeNS("http://www.opengis.net/gml/3.2", "id"), (String)this.featureId, (String)ErrorMessage.get("UnexpectedIdentifier"));
    }

    String findFeatureIdentifier(Document wfsMetadata) {
        List<QName> featureTypeList = ServiceMetadataUtils.getFeatureTypes(wfsMetadata);
        Set<ConformanceClass> claims = ServiceMetadataUtils.getConformanceClaims(wfsMetadata);
        String id = null;
        for (QName featureType : featureTypeList) {
            NodeList members;
            if (claims.contains((Object)ConformanceClass.BASIC_WFS)) {
                Document rspEntity = this.wfsClient.getFeatureByType(featureType, 1, null);
                members = rspEntity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
                if (members.getLength() == 0) continue;
                Element feature = (Element)members.item(0);
                id = feature.getAttributeNS("http://www.opengis.net/gml/3.2", "id");
                break;
            }
            members = this.executeGetFeatureByType(featureType, null);
            if (members.getLength() == 0) continue;
            Element feature = (Element)members.item(0);
            id = feature.getAttributeNS("http://www.opengis.net/gml/3.2", "id");
            break;
        }
        return id;
    }

    NodeList executeGetFeatureByType(QName featureType, ProtocolBinding binding) {
        NodeList members;
        if (null == binding || binding.equals((Object)ProtocolBinding.ANY)) {
            binding = ServiceMetadataUtils.getOperationBindings(this.wfsMetadata, "GetFeature").iterator().next();
        }
        WFSRequest.appendStoredQuery(this.reqEntity, "urn:ogc:def:query:OGC-WFS::GetFeatureByType", Collections.singletonMap("typeName", featureType));
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        Document entity = this.extractBodyAsDocument(rsp, binding);
        String xpath = "/wfs:FeatureCollection/wfs:member/*";
        HashMap<String, String> bindings = new HashMap<String, String>();
        bindings.put("http://www.opengis.net/wfs/2.0", "wfs");
        try {
            members = XMLUtils.evaluateXPath(entity, xpath, bindings);
        }
        catch (XPathExpressionException e) {
            throw new RuntimeException(e);
        }
        return members;
    }
}

