/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.opengis.cite.iso19142.ConformanceClass;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.util.NamespaceBindings;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.util.FactoryException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceMetadataUtils {
    public static URI getOperationEndpoint(Document wfsMetadata, String opName, ProtocolBinding binding) {
        if (null == binding || binding.equals((Object)ProtocolBinding.ANY)) {
            binding = ServiceMetadataUtils.getOperationBindings(wfsMetadata, opName).iterator().next();
        }
        if (binding.equals((Object)ProtocolBinding.SOAP)) {
            binding = ProtocolBinding.POST;
        }
        StringBuilder method = new StringBuilder(binding.toString());
        method.replace(1, method.length(), method.substring(1).toLowerCase());
        NamespaceBindings nsBindings = new NamespaceBindings();
        nsBindings.addNamespaceBinding("http://www.opengis.net/ows/1.1", "ows");
        nsBindings.addNamespaceBinding("http://www.w3.org/1999/xlink", "xlink");
        String expr = String.format("//ows:Operation[@name='%s']//ows:%s/@xlink:href", opName, method.toString());
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsBindings);
        URI endpoint = null;
        try {
            String href = xpath.evaluate(expr, wfsMetadata);
            endpoint = URI.create(href);
        }
        catch (XPathExpressionException ex) {
            TestSuiteLogger.log(Level.INFO, ex.getMessage());
        }
        if (null != endpoint.getQuery()) {
            String uri = endpoint.toString();
            endpoint = URI.create(uri.substring(0, uri.indexOf(63)));
        }
        return endpoint;
    }

    public static Map<String, URI> getRequestEndpoints(Document wfsMetadata, String reqName) {
        NamespaceBindings nsBindings = NamespaceBindings.withStandardBindings();
        String expr = String.format("//ows:Operation[@name='%s']/descendant::*[@xlink:href]", reqName);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsBindings);
        HashMap<String, URI> endpoints = null;
        try {
            NodeList methodNodes = (NodeList)xpath.evaluate(expr, wfsMetadata, XPathConstants.NODESET);
            if (null == methodNodes || methodNodes.getLength() == 0) {
                return null;
            }
            endpoints = new HashMap<String, URI>();
            for (int i = 0; i < methodNodes.getLength(); ++i) {
                Element methodElem = (Element)methodNodes.item(i);
                String methodName = methodElem.getLocalName().toUpperCase();
                String href = methodElem.getAttributeNS("http://www.w3.org/1999/xlink", "href");
                if (href.indexOf(63) > 0) {
                    href = href.substring(0, href.indexOf(63));
                }
                endpoints.put(methodName, URI.create(href));
            }
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.INFO, xpe.getMessage());
        }
        return endpoints;
    }

    public static List<QName> getFeatureTypes(Document wfsMetadata) {
        String xpath = "//wfs:FeatureType/wfs:Name";
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/wfs/2.0", "wfs");
        NodeList typeNames = null;
        try {
            typeNames = XMLUtils.evaluateXPath(wfsMetadata, xpath, nsBindings);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.INFO, "Failed to evaluate XPath expression: " + xpath, xpe);
        }
        ArrayList<QName> featureTypes = new ArrayList<QName>();
        for (int i = 0; i < typeNames.getLength(); ++i) {
            Node typeName = typeNames.item(i);
            featureTypes.add(ServiceMetadataUtils.buildQName(typeName));
        }
        return featureTypes;
    }

    public static Map<QName, FeatureTypeInfo> extractFeatureInfo(Document wfsCapabilities) {
        HashMap<QName, FeatureTypeInfo> featureInfo = new HashMap<QName, FeatureTypeInfo>();
        NodeList featureTypes = wfsCapabilities.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "FeatureType");
        for (int i = 0; i < featureTypes.getLength(); ++i) {
            FeatureTypeInfo typeInfo = new FeatureTypeInfo();
            NodeList children = featureTypes.item(i).getChildNodes();
            for (int j = 0; j < children.getLength(); ++j) {
                Node child = children.item(j);
                if (child.getNodeType() != 1) continue;
                if (child.getLocalName().equals("Name")) {
                    QName typeName = ServiceMetadataUtils.buildQName(child);
                    typeInfo.setTypeName(typeName);
                }
                if (!child.getLocalName().equals("DefaultCRS")) continue;
                try {
                    typeInfo.setDefaultCRS(child.getTextContent());
                    continue;
                }
                catch (FactoryException e) {
                    TestSuiteLogger.log(Level.WARNING, "Failed to set default CRS.", (Exception)((Object)e));
                }
            }
            featureInfo.put(typeInfo.getTypeName(), typeInfo);
        }
        return featureInfo;
    }

    public static QName buildQName(Node node) {
        String localPart;
        String nsName = null;
        String name = node.getTextContent();
        int indexOfColon = name.indexOf(58);
        if (indexOfColon > 0) {
            localPart = name.substring(indexOfColon + 1);
            nsName = node.lookupNamespaceURI(name.substring(0, indexOfColon));
        } else {
            localPart = name;
            nsName = node.lookupNamespaceURI(null);
        }
        return new QName(nsName, localPart);
    }

    public static Set<ProtocolBinding> getGlobalBindings(Document wfsMetadata) {
        if (null == wfsMetadata) {
            throw new NullPointerException("WFS metadata document is null.");
        }
        EnumSet<ProtocolBinding> globalBindings = EnumSet.noneOf(ProtocolBinding.class);
        String xpath = "//ows:OperationsMetadata/ows:Constraint[@name='%s' and (ows:DefaultValue = 'TRUE')]";
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put("http://www.opengis.net/ows/1.1", "ows");
        try {
            if (XMLUtils.evaluateXPath(wfsMetadata, String.format(xpath, "KVPEncoding"), nsBindings).getLength() > 0) {
                globalBindings.add(ProtocolBinding.GET);
            }
            if (XMLUtils.evaluateXPath(wfsMetadata, String.format(xpath, "XMLEncoding"), nsBindings).getLength() > 0) {
                globalBindings.add(ProtocolBinding.POST);
            }
            if (XMLUtils.evaluateXPath(wfsMetadata, String.format(xpath, "SOAPEncoding"), nsBindings).getLength() > 0) {
                globalBindings.add(ProtocolBinding.SOAP);
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException("Error evaluating XPath expression against capabilities doc. ", xpe);
        }
        return globalBindings;
    }

    public static Set<ProtocolBinding> getOperationBindings(Document wfsMetadata, String opName) {
        HashSet<ProtocolBinding> protoBindings = new HashSet<ProtocolBinding>();
        String expr = "//ows:Operation[@name='%s']/ows:Constraint[@name='%s' and (ows:DefaultValue = 'TRUE')]";
        for (ProtocolBinding binding : EnumSet.allOf(ProtocolBinding.class)) {
            String xpath = String.format(expr, opName, binding.getConstraintName());
            try {
                if (XMLUtils.evaluateXPath(wfsMetadata, xpath, null).getLength() <= 0) continue;
                protoBindings.add(ProtocolBinding.GET);
            }
            catch (XPathExpressionException xpe) {
                throw new RuntimeException("Error evaluating XPath expression against capabilities doc. ", xpe);
            }
        }
        protoBindings.addAll(ServiceMetadataUtils.getGlobalBindings(wfsMetadata));
        if (opName.equals("Transaction")) {
            protoBindings.remove((Object)ProtocolBinding.GET);
        }
        return protoBindings;
    }

    public static Set<ConformanceClass> getConformanceClaims(Document wfsMetadata) {
        EnumSet<ConformanceClass> conformanceSet = EnumSet.allOf(ConformanceClass.class);
        String expr = "//ows:Constraint[@name='%s' and (ows:DefaultValue = 'TRUE')]";
        for (ConformanceClass conformClass : conformanceSet) {
            NodeList result;
            String xpath = String.format(expr, conformClass.getConstraintName());
            try {
                result = XMLUtils.evaluateXPath(wfsMetadata, xpath, null);
            }
            catch (XPathExpressionException xpe) {
                throw new RuntimeException("Error evaluating XPath expression against capabilities doc. " + xpath, xpe);
            }
            if (result.getLength() != 0) continue;
            conformanceSet.remove((Object)conformClass);
        }
        return conformanceSet;
    }
}

