/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.validation;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.dom.NodeOverNodeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XPathCompiler;
import net.sf.saxon.s9api.XPathExecutable;
import net.sf.saxon.s9api.XPathSelector;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmDestination;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmValue;
import net.sf.saxon.s9api.XsltCompiler;
import net.sf.saxon.s9api.XsltExecutable;
import net.sf.saxon.s9api.XsltTransformer;
import org.apache.xml.resolver.CatalogManager;
import org.apache.xml.resolver.tools.CatalogResolver;
import org.opengis.cite.validation.RelaxNGValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SchematronValidator {
    private static final Logger LOGR = Logger.getLogger(SchematronValidator.class.getPackage().getName());
    public static final String ISO_SCHEMATRON_SVRL_NS = "http://purl.oclc.org/dsdl/svrl";
    private static String INCLUDE_XSLT = "iso_dsdl_include.xsl";
    private static String ABSTRACT_EXPAND_XSLT = "iso_abstract_expand.xsl";
    private static String SVRL_REPORT_XSLT = "iso_svrl_xslt2.xsl";
    private Processor processor;
    private XsltTransformer validator;
    private int totalRuleViolations = 0;

    public SchematronValidator(Source schema, String phase) throws Exception {
        if (schema == null) {
            throw new IllegalArgumentException("No schema Source provided.");
        }
        this.processor = new Processor(false);
        this.processor.setConfigurationProperty("http://saxon.sf.net/feature/recoveryPolicy", (Object)0);
        XsltExecutable xslt = this.compileSchema(schema, phase);
        this.validator = xslt.load();
    }

    public ValidationErrorHandler validateSchema(Source schema) throws IOException {
        RelaxNGValidator rngValidator;
        try {
            rngValidator = new RelaxNGValidator(this.getClass().getResource("rnc/schematron-grammar.rnc"));
            rngValidator.validate(schema);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        return rngValidator.getErrorHandler();
    }

    public int getRuleViolationCount() {
        return this.totalRuleViolations;
    }

    public boolean ruleViolationsDetected() {
        return this.totalRuleViolations > 0;
    }

    public void setParameters(Map<String, String> params) {
        for (Map.Entry<String, String> entry : params.entrySet()) {
            String paramName = entry.getKey();
            String paramValue = entry.getValue();
            this.validator.setParameter(new QName(paramName), (XdmValue)new XdmAtomicValue(paramValue));
        }
    }

    public DOMResult validate(Source xmlSource) {
        if (xmlSource == null) {
            throw new IllegalArgumentException("Nothing to validate.");
        }
        this.totalRuleViolations = 0;
        XdmDestination results = new XdmDestination();
        try {
            this.validator.setSource(xmlSource);
            this.validator.setDestination((Destination)results);
            this.validator.transform();
        }
        catch (SaxonApiException e1) {
            LOGR.warning(e1.getMessage());
        }
        this.totalRuleViolations = this.countRuleViolations(results);
        if (LOGR.isLoggable(Level.FINER)) {
            LOGR.log(Level.FINER, "{0} Schematron rule violations found", this.totalRuleViolations);
            this.writeResultsToTempFile(results);
        }
        NodeInfo nodeInfo = results.getXdmNode().getUnderlyingNode();
        return new DOMResult((Node)NodeOverNodeInfo.wrap((NodeInfo)nodeInfo));
    }

    final XsltExecutable compileSchema(Source schema, String phase) throws Exception {
        XsltCompiler compiler = this.processor.newXsltCompiler();
        CatalogManager manager = new CatalogManager("org/opengis/cite/validation/CatalogManager.properties");
        compiler.setURIResolver((URIResolver)new CatalogResolver(manager));
        XsltExecutable includeXslt = compiler.compile((Source)new StreamSource(SchematronValidator.class.getResourceAsStream(INCLUDE_XSLT)));
        XsltExecutable abstractXslt = compiler.compile((Source)new StreamSource(SchematronValidator.class.getResourceAsStream(ABSTRACT_EXPAND_XSLT)));
        XsltExecutable svrlXslt = compiler.compile((Source)new StreamSource(SchematronValidator.class.getResourceAsStream(SVRL_REPORT_XSLT)));
        XsltTransformer stage1Transformer = includeXslt.load();
        XsltTransformer stage2Transformer = abstractXslt.load();
        XsltTransformer stage3Transformer = svrlXslt.load();
        stage1Transformer.setSource(schema);
        stage1Transformer.setDestination((Destination)stage2Transformer);
        stage2Transformer.setDestination((Destination)stage3Transformer);
        XdmDestination chainResult = new XdmDestination();
        stage3Transformer.setDestination((Destination)chainResult);
        if (phase != null && !phase.equals("")) {
            stage3Transformer.setParameter(new QName("phase"), (XdmValue)new XdmAtomicValue(phase));
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream console = System.err;
        try {
            System.setErr(new PrintStream(baos));
            stage1Transformer.transform();
        }
        catch (SaxonApiException e) {
            throw new Exception(baos.toString() + e.getMessage(), e.getCause());
        }
        finally {
            System.setErr(console);
        }
        XsltExecutable compiledStylesheet = compiler.compile(chainResult.getXdmNode().asSource());
        return compiledStylesheet;
    }

    private void writeResultsToTempFile(XdmDestination xdmResult) {
        File temp = null;
        try {
            temp = File.createTempFile("SchematronValidator-dump-", ".xml");
            BufferedWriter out = new BufferedWriter(new FileWriter(temp));
            out.write(xdmResult.getXdmNode().toString());
            out.close();
        }
        catch (IOException e) {
            LOGR.warning(e.getMessage());
        }
        if (temp.exists()) {
            LOGR.log(Level.FINER, "Dumped Schematron results to {0}", temp.getAbsolutePath());
        }
    }

    private int countRuleViolations(XdmDestination results) {
        XPathCompiler xpath = this.processor.newXPathCompiler();
        xpath.declareNamespace("svrl", ISO_SCHEMATRON_SVRL_NS);
        XdmAtomicValue totalCount = null;
        try {
            XPathExecutable exe = xpath.compile("count(//svrl:failed-assert) + count(//svrl:successful-report)");
            XPathSelector selector = exe.load();
            selector.setContextItem((XdmItem)results.getXdmNode());
            totalCount = (XdmAtomicValue)selector.evaluateSingle();
        }
        catch (SaxonApiException e) {
            LOGR.warning(e.getMessage());
        }
        return Integer.parseInt(totalCount.getValue().toString());
    }
}

