/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.locking;

import com.sun.jersey.api.client.ClientResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.DataSampler;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.testng.ITestContext;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.w3c.dom.Document;

public class LockingFixture
extends BaseFixture {
    protected List<String> locks = new ArrayList<String>();
    protected DataSampler dataSampler;

    @BeforeClass(alwaysRun=true)
    public void initLockingFixture(ITestContext testContext) {
        this.dataSampler = (DataSampler)testContext.getSuite().getAttribute(SuiteAttribute.SAMPLER.getName());
        this.featureInfo = this.dataSampler.getFeatureTypeInfo();
    }

    @AfterMethod(alwaysRun=true)
    public void releaseAllLocks() {
        if (this.locks.isEmpty()) {
            return;
        }
        Document trxEntity = WFSRequest.createRequestEntity("Transaction");
        trxEntity.getDocumentElement().setAttribute("releaseAction", "ALL");
        for (String lockId : this.locks) {
            trxEntity.getDocumentElement().setAttribute("lockId", lockId);
            ClientResponse rsp = this.wfsClient.submitRequest(trxEntity, ProtocolBinding.ANY);
            if (rsp.getStatus() == ClientResponse.Status.OK.getStatusCode()) continue;
            String entity = (String)rsp.getEntity(String.class);
            TestSuiteLogger.log(Level.WARNING, "Failed to release lock " + lockId + "\n" + entity);
        }
        this.locks.clear();
    }
}

