/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.transaction;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.joda.time.DateTime;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.transaction.TransactionFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Update
extends TransactionFixture {
    private List<Element> modifiedFeatures = new ArrayList<Element>();

    @AfterClass
    public void restoreModifiedFeatures() {
        Boolean result;
        if (this.modifiedFeatures.isEmpty()) {
            return;
        }
        Document req = WFSRequest.createRequestEntity("Transaction");
        WFSRequest.addReplaceStatements(req, this.modifiedFeatures);
        ClientResponse rsp = this.wfsClient.submitRequest(req, ProtocolBinding.ANY);
        Document rspEntity = (Document)rsp.getEntity(Document.class);
        String expr = String.format("//wfs:totalReplaced = '%d'", this.modifiedFeatures.size());
        try {
            result = (Boolean)XMLUtils.evaluateXPath(rspEntity, expr, null, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        if (!result.booleanValue()) {
            String msg = String.format("%s: Failed to replace modified features.\n%s", this.getClass().getName(), XMLUtils.writeNodeToString(rspEntity));
            TestSuiteLogger.log(Level.WARNING, msg);
        }
    }

    @Test(description="See ISO 19142: 15.3.3, 15.3.5", dataProvider="binding+availFeatureType")
    public void updateGMLName(ProtocolBinding binding, QName featureType) {
        Document doc = this.wfsClient.getFeatureByType(featureType, 1, null);
        NodeList features = doc.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        Element originalFeature = (Element)features.item(0);
        String gmlId = originalFeature.getAttributeNS("http://www.opengis.net/gml/3.2", "id");
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("gml:name[1]", "Ce n&apos;est pas Vieux-Port de Montr&#xe9;al!");
        this.rspEntity = this.wfsClient.updateFeature(this.reqEntity, gmlId, featureType, properties, binding);
        if (this.rspEntity.getDocumentElement().getLocalName().equals("TransactionResponse")) {
            this.modifiedFeatures.add(originalFeature);
        }
        ETSAssert.assertFeatureProperties(gmlId, properties, null, this.wfsClient);
    }

    @Test(description="See ISO 19142: 7.5, 15.2.5.2.1")
    public void updateBoundedByWithKMLPoint() {
        try {
            this.reqEntity = this.docBuilder.parse(this.getClass().getResourceAsStream("UpdateInvalidFeatureProperty.xml"));
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse XML resource from classpath", e);
        }
        Element update = (Element)this.reqEntity.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Update").item(0);
        WFSRequest.setTypeName(update, (QName)this.featureTypes.get(0));
        ProtocolBinding binding = this.wfsClient.getAnyTransactionBinding();
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "Transaction", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        String xpath = "//ows:Exception[@exceptionCode = 'InvalidValue']";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }

    @Test(description="See ISO 19142: 15.3.3, 15.3.5", dataProvider="binding+availFeatureType")
    public void updateSimplePropertyValue(ProtocolBinding binding, QName featureType) {
        List<XSElementDeclaration> simpleProps = AppSchemaUtils.getSimpleFeatureProperties(this.model, featureType);
        ListIterator<XSElementDeclaration> propItr = simpleProps.listIterator(simpleProps.size());
        XSElementDeclaration prop = propItr.previous();
        Set<String> identifiers = this.dataSampler.selectRandomFeatureIdentifiers(featureType, 1);
        String featureId = identifiers.iterator().next();
        QName propName = new QName(prop.getNamespace(), prop.getName(), "tns");
        List<String> propValues = this.dataSampler.getSimplePropertyValues(featureType, propName, featureId);
        String newVal = this.newPropertyValue(prop, propValues);
        WFSRequest.addNamespaceBinding(this.reqEntity, propName);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put(propName.getPrefix() + ":" + propName.getLocalPart() + "[1]", newVal);
        this.rspEntity = this.wfsClient.updateFeature(this.reqEntity, featureId, featureType, properties, binding);
        if (this.rspEntity.getDocumentElement().getLocalName().equals("TransactionResponse")) {
            this.modifiedFeatures.add(this.dataSampler.getFeatureById(featureId));
        }
        ETSAssert.assertFeatureProperties(featureId, properties, Collections.singletonMap(propName.getNamespaceURI(), propName.getPrefix()), this.wfsClient);
    }

    String newPropertyValue(XSElementDeclaration prop, List<String> propValues) {
        XSSimpleTypeDefinition propType;
        if (prop.getTypeDefinition().getTypeCategory() == 16) {
            propType = (XSSimpleTypeDefinition)prop.getTypeDefinition();
        } else {
            XSComplexTypeDefinition complexType = (XSComplexTypeDefinition)prop.getTypeDefinition();
            propType = complexType.getSimpleType();
        }
        StringList enums = propType.getLexicalEnumeration();
        for (int i = 0; i < enums.getLength(); ++i) {
            if (propValues.contains(enums.item(i))) continue;
            return enums.item(i);
        }
        String newValue = null;
        switch (propType.getBuiltInKind()) {
            case 2: {
                newValue = "TEST_VALUE";
                break;
            }
            case 8: {
                DateTime now = new DateTime();
                newValue = now.toString();
                break;
            }
            case 6: {
                Double val = Double.valueOf(propValues.get(0));
                newValue = Double.toString(Math.log(val));
                break;
            }
            default: {
                newValue = "";
            }
        }
        return newValue;
    }
}

