/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.level2;

import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml22.BaseFixture;
import org.opengis.cite.kml22.ETSAssert;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class StyleRecommendations
extends BaseFixture {
    @Test(description="Implements ATC 42")
    public void verifyPolyStyle() {
        NodeList polyStyleNodes = null;
        try {
            polyStyleNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:PolyStyle[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < polyStyleNodes.getLength(); ++i) {
            Node polyStyle = polyStyleNodes.item(i);
            try {
                ETSAssert.assertXPath("kml:color or kml:colorMode or kml:fill or kml:outline", polyStyle, NS_MAP);
                continue;
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.PolyStyle.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(polyStyle)));
            }
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 58")
    public void verifyBalloonStyleNotEmpty() {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        this.verifyElementNotEmpty("BalloonStyle", errHandler);
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 61")
    public void verifyIconStyleNotEmpty() {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        this.verifyElementNotEmpty("IconStyle", errHandler);
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 63")
    public void verifyLabelStyleNotEmpty() {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        this.verifyElementNotEmpty("LabelStyle", errHandler);
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 64")
    public void verifyListStyle() {
        NodeList listStyleNodes = null;
        try {
            listStyleNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:ListStyle[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < listStyleNodes.getLength(); ++i) {
            Node listStyle = listStyleNodes.item(i);
            try {
                ETSAssert.assertXPath("kml:listItemType or kml:bgColor or kml:ItemIcon", listStyle, NS_MAP);
                continue;
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.ListStyle.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(listStyle)));
            }
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 65")
    public void verifyStyleNotEmpty() {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        this.verifyElementNotEmpty("Style", errHandler);
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 68")
    public void verifyStyleMapPairs() {
        NodeList styleMapNodes = null;
        try {
            styleMapNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:StyleMap[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < styleMapNodes.getLength(); ++i) {
            Node styleMap = styleMapNodes.item(i);
            try {
                ETSAssert.assertXPath("kml:Pair[kml:key='normal'] and kml:Pair[kml:key='highlight']", styleMap, NS_MAP);
                continue;
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.StyleMap.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(styleMap)));
            }
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }
}

