/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.util;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import org.apache.xerces.util.XMLCatalogResolver;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.URIUtils;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.opengis.cite.validation.XmlSchemaCompiler;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class ValidationUtils {
    private static final String ROOT_PKG = "/org/opengis/cite/kml22/";
    private static final XMLCatalogResolver SCH_RESOLVER = ValidationUtils.initCatalogResolver();

    private static XMLCatalogResolver initCatalogResolver() {
        URL catalogURL = ValidationUtils.class.getResource("/org/opengis/cite/kml22/schematron-catalog.xml");
        XMLCatalogResolver resolver = new XMLCatalogResolver();
        resolver.setCatalogList(new String[]{catalogURL.toString()});
        return resolver;
    }

    public static SchematronValidator buildSchematronValidator(String schemaRef, String phase) {
        StreamSource source = null;
        try {
            String catalogRef = SCH_RESOLVER.resolveSystem(schemaRef.toString());
            source = null != catalogRef ? new StreamSource(URI.create(catalogRef).toString()) : new StreamSource(schemaRef);
        }
        catch (IOException x) {
            TestSuiteLogger.log(Level.WARNING, "Error reading Schematron schema catalog.", x);
        }
        SchematronValidator validator = null;
        try {
            validator = new SchematronValidator((Source)source, phase);
        }
        catch (Exception e) {
            TestSuiteLogger.log(Level.WARNING, "Error creating Schematron validator.", e);
        }
        return validator;
    }

    public static URI extractSchemaReference(Source source, String baseURI) throws XMLStreamException {
        XMLInputFactory factory = XMLInputFactory.newInstance();
        XMLEventReader reader = factory.createXMLEventReader(source);
        StartElement docElem = reader.nextTag().asStartElement();
        QName qName = docElem.getName();
        String namespace = qName.getNamespaceURI();
        Attribute schemaLoc = docElem.getAttributeByName(new QName("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation"));
        String[] uriValues = new String[]{};
        if (null != schemaLoc) {
            uriValues = schemaLoc.getValue().split("\\s");
        }
        URI schemaURI = null;
        for (int i = 0; i < uriValues.length; i += 2) {
            if (!uriValues[i].equals(namespace)) continue;
            if (!URI.create(uriValues[i + 1]).isAbsolute() && null != source.getSystemId()) {
                String schemaRef = URIUtils.resolveRelativeURI(source.getSystemId(), uriValues[i + 1]).toString();
                if (schemaRef.startsWith("file") && !new File(schemaRef).exists() && null != baseURI) {
                    schemaRef = URIUtils.resolveRelativeURI(baseURI, uriValues[i + 1]).toString();
                }
                schemaURI = URI.create(schemaRef);
                break;
            }
            schemaURI = URI.create(uriValues[i + 1]);
            break;
        }
        return schemaURI;
    }

    public static Schema createKMLSchema() {
        URL entityCatalog = ValidationUtils.class.getResource("/org/opengis/cite/kml22/schema-catalog.xml");
        XmlSchemaCompiler xsdCompiler = new XmlSchemaCompiler(entityCatalog);
        Schema kmlSchema = null;
        try {
            URL schemaURL = ValidationUtils.class.getResource("/org/opengis/cite/kml22/xsd/ogc/kml/2.2.0/ogckml22.xsd");
            StreamSource xsdSource = new StreamSource(schemaURL.toString());
            kmlSchema = xsdCompiler.compileXmlSchema(new Source[]{xsdSource});
        }
        catch (SAXException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to create KML Schema object.", e);
        }
        return kmlSchema;
    }

    public static void validateCoordinateTuples(Node coordinates, int minDim, ValidationErrorHandler errHandler) {
        if (!coordinates.getLocalName().equals("coordinates")) {
            return;
        }
        int minTupleDim = minDim < 2 || minDim > 3 ? 2 : minDim;
        String xpointer = XMLUtils.getXPointer(coordinates);
        String coords = coordinates.getTextContent();
        String[] tuples = coords.trim().split("[ \\t\\n\\r]{1,}");
        for (int i = 0; i < tuples.length; ++i) {
            String[] tuple;
            block6: {
                tuple = tuples[i].trim().split(",");
                if (tuple.length < minTupleDim || tuple.length > 3) {
                    errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.GeometryCoordinates.dim", minTupleDim, i + 1), new ErrorLocator(-1, -1, xpointer));
                    continue;
                }
                try {
                    Float.valueOf(tuple[0]);
                    Float.valueOf(tuple[1]);
                    if (tuple.length != 3) break block6;
                    Float.valueOf(tuple[2]);
                }
                catch (NumberFormatException e) {
                    errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.GeometryCoordinates.float", i + 1), new ErrorLocator(-1, -1, xpointer));
                    continue;
                }
            }
            if ((double)Float.valueOf(tuple[0]).floatValue() < -180.0 || (double)Float.valueOf(tuple[0]).floatValue() > 180.0) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.GeometryCoordinates.lon", i + 1), new ErrorLocator(-1, -1, xpointer));
            }
            if (!((double)Float.valueOf(tuple[1]).floatValue() < -90.0) && !((double)Float.valueOf(tuple[1]).floatValue() > 90.0)) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level1.GeometryCoordinates.lat", i + 1), new ErrorLocator(-1, -1, xpointer));
        }
    }
}

