/*
 * Decompiled with CFR 0.152.
 */
package com.galdosinc.glib.gml.coord;

import com.galdosinc.glib.gml.coord.CoordinateException;
import com.galdosinc.glib.gml.coord.CoordinateTupleList;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class CoordinateTupleLinkedList
implements CoordinateTupleList {
    private List tupleList_ = new LinkedList();
    private int dimension_ = -1;

    @Override
    public int getDimension() {
        return this.dimension_;
    }

    @Override
    public int getCoordinateTupleCount() {
        return this.tupleList_.size();
    }

    @Override
    public void setCoordinateTuples(double[][] tuples, boolean canBeAdopted) throws CoordinateException {
        LinkedList<double[]> tupleList = new LinkedList<double[]>();
        for (int ii = 0; ii < tuples.length; ++ii) {
            tupleList.add(tuples[ii]);
        }
        this.setCoordinateTuplesInternal(tupleList);
    }

    @Override
    public void setCoordinateTuples(List tupleList, boolean canBeAdopted) throws CoordinateException {
        if (canBeAdopted && tupleList instanceof LinkedList) {
            this.setCoordinateTuplesInternal((LinkedList)tupleList);
        } else {
            LinkedList<double[]> newTupleList = new LinkedList<double[]>();
            for (double[] otherTuple : newTupleList) {
                double[] newTuple = new double[otherTuple.length];
                System.arraycopy(otherTuple, 0, newTuple, 0, otherTuple.length);
                newTupleList.add(newTuple);
            }
            this.setCoordinateTuplesInternal(newTupleList);
        }
    }

    private void setCoordinateTuplesInternal(LinkedList tupleList) throws CoordinateException {
        this.tupleList_.clear();
        this.tupleList_.addAll(tupleList);
        if (this.tupleList_.isEmpty()) {
            this.dimension_ = -1;
        } else {
            Object firstItem = this.tupleList_.get(0);
            if (firstItem instanceof double[]) {
                this.dimension_ = ((double[])firstItem).length;
            } else {
                throw new CoordinateException("The members of the coordinate tuple list must be arrays of doubles.", null);
            }
        }
    }

    private double[] cloneTouple(double[] source) {
        double[] clone = new double[source.length];
        System.arraycopy(source, 0, clone, 0, source.length);
        return clone;
    }

    private void cloneListMembers(List source, List target) {
        for (double[] nextTuple : source) {
            double[] clonedNextTouple = this.cloneTouple(nextTuple);
            target.add(clonedNextTouple);
        }
    }

    @Override
    public List asLiveList() {
        return this.tupleList_;
    }

    @Override
    public List asRandomAccessList(boolean allowLiveList) {
        ArrayList result = new ArrayList();
        this.cloneListMembers(this.tupleList_, result);
        return result;
    }

    @Override
    public List asSequentialAccessList(boolean allowLiveList) {
        if (allowLiveList) {
            return this.tupleList_;
        }
        LinkedList result = new LinkedList();
        this.cloneListMembers(this.tupleList_, result);
        return result;
    }

    @Override
    public double[][] asArray(boolean allowLiveArray) {
        if (this.tupleList_.size() == 0) {
            return new double[0][0];
        }
        double[][] result = new double[this.tupleList_.size()][];
        this.tupleList_.toArray((T[])result);
        return result;
    }

    @Override
    public double[][] asArray(double[][] tuples) {
        this.tupleList_.toArray((T[])tuples);
        return tuples;
    }
}

