/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.ctlfns;

import java.io.ByteArrayOutputStream;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.NamespaceContext;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GmlSchemaValidator {
    private static final Logger LOGR = Logger.getLogger(GmlSchemaValidator.class.getName());
    Hashtable namespaceHash = new Hashtable();
    final String config_property = "org.apache.xerces.xni.parser.XMLParserConfiguration";

    public GmlSchemaValidator(Document namespaces) {
        NodeList nl = namespaces.getElementsByTagName("namespace");
        for (int i = 0; i < nl.getLength(); ++i) {
            Element e = (Element)nl.item(i);
            this.namespaceHash.put(e.getAttribute("prefix"), e.getAttribute("uri"));
        }
    }

    private Object execute(String baseUri, Node schema, List featureTypeNames) throws Exception {
        Element report = null;
        Transformer t = TransformerFactory.newInstance().newTransformer();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        t.transform(new DOMSource(schema), new StreamResult(baos));
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        Class<?> qname_class = loader.loadClass("com.galdosinc.glib.xml.QName");
        Method setNamespaceUri = qname_class.getMethod("setNamespaceUri", String.class);
        Method setLocalName = qname_class.getMethod("setLocalName", String.class);
        ArrayList QNames = new ArrayList();
        ListIterator it = featureTypeNames.listIterator();
        while (it.hasNext()) {
            String name = (String)it.next();
            int colon = name.indexOf(":");
            String prefix = name.substring(0, colon);
            Object qname_instance = qname_class.newInstance();
            setNamespaceUri.invoke(qname_instance, this.namespaceHash.get(prefix));
            setLocalName.invoke(qname_instance, name.substring(colon + 1));
            QNames.add(qname_instance);
        }
        Class<?> validator_class = loader.loadClass("com.galdosinc.glib.gml.validator.XPathGmlSchemaValidator");
        Method execute = validator_class.getMethod("execute", String.class, String.class, List.class);
        Object validator_instance = validator_class.newInstance();
        String old_config_property = System.getProperty("org.apache.xerces.xni.parser.XMLParserConfiguration");
        System.clearProperty("org.apache.xerces.xni.parser.XMLParserConfiguration");
        try {
            report = (Element)execute.invoke(validator_instance, baseUri, baos.toString(), QNames);
        }
        catch (Exception e) {
            LOGR.log(Level.WARNING, "Failed to invoke " + validator_instance.getClass().getName(), e);
        }
        if (old_config_property != null) {
            System.setProperty("org.apache.xerces.xni.parser.XMLParserConfiguration", old_config_property);
        }
        if (report == null) {
            LOGR.log(Level.WARNING, "Null result returned by  " + validator_instance.getClass().getName() + ": " + QNames);
            return null;
        }
        XPath xpath = XPathFactory.newInstance().newXPath();
        SvrContext namespaces = new SvrContext();
        xpath.setNamespaceContext(namespaces);
        XPathExpression expression = xpath.compile("count(svr:ElementReport) = 0 and count(svr:Error) = 0");
        Boolean result = (Boolean)expression.evaluate(report, XPathConstants.BOOLEAN);
        return result;
    }

    public Object validate(String baseUri, Node schema) throws Exception {
        return this.execute(baseUri, schema, new ArrayList());
    }

    public Object validate(String baseUri, Node schema, String featureTypeName1) throws Exception {
        ArrayList<String> featureTypeNames = new ArrayList<String>();
        featureTypeNames.add(featureTypeName1);
        return this.execute(baseUri, schema, featureTypeNames);
    }

    public Object validate(String baseUri, Node schema, String featureTypeName1, String featureTypeName2) throws Exception {
        ArrayList<String> featureTypeNames = new ArrayList<String>();
        featureTypeNames.add(featureTypeName1);
        featureTypeNames.add(featureTypeName2);
        return this.execute(baseUri, schema, featureTypeNames);
    }

    public Object validate(String baseUri, Node schema, String featureTypeName1, String featureTypeName2, String featureTypeName3) throws Exception {
        ArrayList<String> featureTypeNames = new ArrayList<String>();
        featureTypeNames.add(featureTypeName1);
        featureTypeNames.add(featureTypeName2);
        featureTypeNames.add(featureTypeName3);
        return this.execute(baseUri, schema, featureTypeNames);
    }

    public Object validate(String baseUri, Node schema, String featureTypeName1, String featureTypeName2, String featureTypeName3, String featureTypeName4) throws Exception {
        ArrayList<String> featureTypeNames = new ArrayList<String>();
        featureTypeNames.add(featureTypeName1);
        featureTypeNames.add(featureTypeName2);
        featureTypeNames.add(featureTypeName3);
        featureTypeNames.add(featureTypeName4);
        return this.execute(baseUri, schema, featureTypeNames);
    }

    public Object validate(String baseUri, Node schema, String featureTypeName1, String featureTypeName2, String featureTypeName3, String featureTypeName4, String featureTypeName5) throws Exception {
        ArrayList<String> featureTypeNames = new ArrayList<String>();
        featureTypeNames.add(featureTypeName1);
        featureTypeNames.add(featureTypeName2);
        featureTypeNames.add(featureTypeName3);
        featureTypeNames.add(featureTypeName4);
        featureTypeNames.add(featureTypeName5);
        return this.execute(baseUri, schema, featureTypeNames);
    }

    private class SvrContext
    implements NamespaceContext {
        static final String SVR = "http://www.galdosinc.com/xml/schema/validation/report";

        private SvrContext() {
        }

        @Override
        public String getNamespaceURI(String prefix) {
            return prefix.equals("svr") ? SVR : "";
        }

        @Override
        public String getPrefix(String namespace) {
            return namespace.equals(SVR) ? "svr" : null;
        }

        public Iterator getPrefixes(String namespace) {
            return null;
        }
    }
}

