/*
 * Decompiled with CFR 0.152.
 */
package com.occamlab.te.parsers;

import com.occamlab.te.ErrorHandlerImpl;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GMLValidatingParser {
    private static final Logger LOGR = Logger.getLogger(GMLValidatingParser.class.getName());
    DocumentBuilderFactory DBF;
    final String builder_property = "javax.xml.parsers.DocumentBuilderFactory";
    final String config_property = "org.apache.xerces.xni.parser.XMLParserConfiguration";

    public GMLValidatingParser(Document document_locations) throws Throwable {
        String old_config_property = System.getProperty("org.apache.xerces.xni.parser.XMLParserConfiguration");
        System.clearProperty("org.apache.xerces.xni.parser.XMLParserConfiguration");
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            Class<?> dbf_class = loader.loadClass("com.galdosinc.glib.xml.jaxp.ValidatingDocumentBuilderFactory");
            this.DBF = (DocumentBuilderFactory)dbf_class.newInstance();
            this.DBF.setNamespaceAware(true);
            this.DBF.setValidating(true);
            NodeList parms = document_locations.getElementsByTagName("parm");
            for (int i = 0; i < parms.getLength(); ++i) {
                Element parm = (Element)parms.item(i);
                NodeList parm_contents = parm.getChildNodes();
                String property_name = null;
                URL schemaURL = null;
                for (int j = 0; j < parm_contents.getLength(); ++j) {
                    Node n = parm_contents.item(j);
                    if (n.getNodeType() != 1) continue;
                    Element e = (Element)n;
                    if (e.getNodeName().equals("name")) {
                        property_name = e.getTextContent();
                    }
                    if (!e.getNodeName().equals("value")) continue;
                    schemaURL = this.schemaRefAsURL(e.getTextContent().trim());
                }
                if (null == schemaURL) continue;
                this.DBF.setAttribute(property_name, schemaURL);
            }
        }
        catch (Exception e) {
            LOGR.warning(e.getMessage());
            throw e;
        }
        if (old_config_property != null) {
            System.setProperty("org.apache.xerces.xni.parser.XMLParserConfiguration", old_config_property);
        }
    }

    URL schemaRefAsURL(String schemaRef) {
        URL schemaURL = null;
        try {
            schemaURL = new URL(schemaRef);
        }
        catch (MalformedURLException mux) {
            ClassLoader loader = this.getClass().getClassLoader();
            schemaURL = loader.getResource(schemaRef);
        }
        if (null == schemaURL) {
            LOGR.warning("Unable to find schema resource at " + schemaRef);
        }
        return schemaURL;
    }

    public Document parse(URLConnection uc, Element instruction, PrintWriter logger) throws Exception {
        Document doc = null;
        ErrorHandlerImpl eh = new ErrorHandlerImpl(null, logger);
        String old_config_property = System.getProperty("org.apache.xerces.xni.parser.XMLParserConfiguration");
        System.clearProperty("org.apache.xerces.xni.parser.XMLParserConfiguration");
        try {
            DocumentBuilder db = this.DBF.newDocumentBuilder();
            db.setErrorHandler(eh);
            doc = db.parse(uc.getInputStream());
        }
        catch (Exception e) {
            logger.println(e.getMessage());
        }
        if (old_config_property != null) {
            System.setProperty("org.apache.xerces.xni.parser.XMLParserConfiguration", old_config_property);
        }
        if (eh.getErrorCount() > 0 || eh.getWarningCount() > 0) {
            logger.println(eh.getErrorCounts());
            logger.flush();
        }
        if (eh.getErrorCount() > 0) {
            return null;
        }
        return doc;
    }

    public static void main(String[] args) throws Throwable {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(args[0]);
        GMLValidatingParser gvp = new GMLValidatingParser(doc);
        URLConnection uc = new URL(args[1]).openConnection();
        gvp.parse(uc, doc.getDocumentElement(), new PrintWriter(System.out));
    }
}

