/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.collection;

import java.lang.ref.WeakReference;
import java.lang.reflect.Array;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jcip.annotations.ThreadSafe;
import org.geotoolkit.internal.ReferenceQueueConsumer;
import org.geotoolkit.resources.Errors;
import org.geotoolkit.util.Disposable;
import org.geotoolkit.util.NullArgumentException;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.XArrays;
import org.geotoolkit.util.logging.Logging;

@ThreadSafe
public class WeakValueHashMap<K, V>
extends AbstractMap<K, V> {
    private static final int MIN_CAPACITY = 7;
    private static final float LOAD_FACTOR = 0.75f;
    private static final long HOLD_TIME = 60000L;
    private Entry[] table;
    private int count;
    private int threshold;
    private long lastRehashTime;
    private transient Set<Map.Entry<K, V>> entrySet;

    public WeakValueHashMap() {
        this(7);
    }

    public WeakValueHashMap(int n) {
        Entry[] entryArray = this.newEntryTable(n);
        this.threshold = Math.round((float)entryArray.length * 0.75f);
        this.lastRehashTime = System.currentTimeMillis();
    }

    private Entry[] newEntryTable(int n) {
        this.table = (Entry[])Array.newInstance(Entry.class, n);
        return this.table;
    }

    public WeakValueHashMap(Map<K, V> map) {
        this(Math.round((float)map.size() / 0.75f) + 1);
        this.putAll(map);
    }

    private synchronized void removeEntry(Entry entry) {
        assert (this.valid());
        int n = entry.index;
        Entry[] entryArray = this.table;
        if (n < entryArray.length) {
            Entry entry2 = null;
            Entry entry3 = entryArray[n];
            while (entry3 != null) {
                if (entry3 == entry) {
                    if (entry2 != null) {
                        entry2.next = entry3.next;
                    } else {
                        entryArray[n] = entry3.next;
                    }
                    --this.count;
                    assert (this.valid());
                    if (this.count <= this.threshold / 4) {
                        this.table = this.rehash(false);
                    }
                    return;
                }
                entry2 = entry3;
                entry3 = entry3.next;
            }
        }
        assert (this.valid());
    }

    private Entry[] rehash(boolean bl) {
        Object object;
        Object object2;
        assert (Thread.holdsLock(this));
        assert (this.valid());
        Entry[] entryArray = this.table;
        long l = System.currentTimeMillis();
        int n = Math.max(Math.round((float)this.count / 0.375f), this.count + 7);
        if (bl ? n <= entryArray.length : n >= entryArray.length || l - this.lastRehashTime < 60000L) {
            return entryArray;
        }
        this.lastRehashTime = l;
        Entry[] entryArray2 = this.newEntryTable(n);
        this.threshold = Math.round((float)n * 0.75f);
        for (int i = 0; i < entryArray.length; ++i) {
            object2 = entryArray[i];
            while (object2 != null) {
                object = object2;
                object2 = ((Entry)object2).next;
                Object k = ((Entry)object).key;
                if (k != null) {
                    int n2;
                    ((Entry)object).index = n2 = WeakValueHashMap.hashCode(k) % entryArray2.length;
                    ((Entry)object).next = entryArray2[n2];
                    entryArray2[n2] = object;
                    continue;
                }
                --this.count;
            }
        }
        Logger logger = Logging.getLogger(WeakValueHashMap.class);
        if (logger.isLoggable((Level)(object2 = Level.FINEST))) {
            object = new LogRecord((Level)object2, "Rehash from " + entryArray.length + " to " + entryArray2.length);
            ((LogRecord)object).setSourceMethodName(bl ? "unique" : "remove");
            ((LogRecord)object).setSourceClassName(WeakValueHashMap.class.getName());
            ((LogRecord)object).setLoggerName(logger.getName());
            logger.log((LogRecord)object);
        }
        assert (this.valid());
        return entryArray2;
    }

    private static int hashCode(Object object) {
        return object != null ? object.hashCode() & Integer.MAX_VALUE : 0;
    }

    private boolean valid() {
        int n;
        if (!Thread.holdsLock(this)) {
            throw new AssertionError();
        }
        int n2 = 0;
        Entry[] entryArray = this.table;
        for (n = 0; n < entryArray.length; ++n) {
            Entry entry = entryArray[n];
            while (entry != null) {
                if (WeakValueHashMap.hashCode(entry.key) % entryArray.length != entry.index) {
                    throw new AssertionError();
                }
                ++n2;
                entry = entry.next;
            }
        }
        n = this.count;
        if (n2 != n) {
            this.count = n2;
            throw new AssertionError(n - n2);
        }
        return true;
    }

    @Override
    public synchronized int size() {
        assert (this.valid());
        return this.count;
    }

    @Override
    public synchronized boolean containsValue(Object object) {
        return super.containsValue(object);
    }

    @Override
    public boolean containsKey(Object object) {
        return this.get(object) != null;
    }

    @Override
    public synchronized V get(Object object) {
        assert (ReferenceQueueConsumer.DEFAULT.isAlive());
        assert (this.valid());
        Entry[] entryArray = this.table;
        int n = WeakValueHashMap.hashCode(object) % entryArray.length;
        Entry entry = entryArray[n];
        while (entry != null) {
            if (object.equals(entry.key)) {
                return (V)entry.get();
            }
            entry = entry.next;
        }
        return null;
    }

    private synchronized V intern(K k, V v) {
        assert (ReferenceQueueConsumer.DEFAULT.isAlive());
        assert (this.valid());
        V v2 = null;
        Entry[] entryArray = this.table;
        int n = WeakValueHashMap.hashCode(k);
        int n2 = n % entryArray.length;
        Entry entry = entryArray[n2];
        while (entry != null) {
            if (k.equals(entry.key)) {
                v2 = (V)entry.get();
                entry.dispose();
                entryArray = this.table;
                n2 = n % entryArray.length;
            }
            entry = entry.next;
        }
        if (v != null) {
            if (this.count >= this.threshold) {
                entryArray = this.rehash(true);
                n2 = n % entryArray.length;
            }
            entryArray[n2] = new Entry(k, v, entryArray[n2], n2);
            ++this.count;
        }
        assert (this.valid());
        return v2;
    }

    @Override
    public V put(K k, V v) {
        if (v == null) {
            throw new NullArgumentException(Errors.format(172, "value"));
        }
        return this.intern(k, v);
    }

    @Override
    public V remove(Object object) {
        return this.intern(object, null);
    }

    @Override
    public synchronized void clear() {
        Arrays.fill(this.table, null);
        this.count = 0;
    }

    @Override
    public synchronized Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private EntrySet() {
        }

        @Override
        public int size() {
            return WeakValueHashMap.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Map.Entry<K, V>[] toArray() {
            WeakValueHashMap weakValueHashMap = WeakValueHashMap.this;
            synchronized (weakValueHashMap) {
                assert (WeakValueHashMap.this.valid());
                Map.Entry[] entryArray = new Map.Entry[this.size()];
                int n = 0;
                Entry[] entryArray2 = WeakValueHashMap.this.table;
                for (int i = 0; i < entryArray2.length; ++i) {
                    Entry entry = entryArray2[i];
                    while (entry != null) {
                        AbstractMap.SimpleEntry simpleEntry = new AbstractMap.SimpleEntry(entry);
                        if (simpleEntry.getValue() != null) {
                            entryArray[n++] = simpleEntry;
                        }
                        entry = entry.next;
                    }
                }
                return XArrays.resize(entryArray, n);
            }
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Arrays.asList(this.toArray()).iterator();
        }
    }

    private final class Entry
    extends WeakReference<V>
    implements Map.Entry<K, V>,
    Disposable {
        final K key;
        Entry next;
        int index;

        Entry(K k, V v, Entry entry, int n) {
            super(v, ReferenceQueueConsumer.DEFAULT.queue);
            this.key = k;
            this.next = entry;
            this.index = n;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.get();
        }

        @Override
        public V setValue(V v) {
            if (v != null) {
                throw new UnsupportedOperationException();
            }
            Object t = this.get();
            this.dispose();
            return t;
        }

        @Override
        public void dispose() {
            WeakValueHashMap.this.removeEntry(this);
            this.clear();
        }

        @Override
        public boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                Map.Entry entry = (Map.Entry)object;
                return Utilities.equals(this.key, entry.getKey()) && Utilities.equals(this.get(), entry.getValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            Object t = this.get();
            Object k = this.key;
            return (k == null ? 0 : k.hashCode()) ^ (t == null ? 0 : t.hashCode());
        }
    }
}

