/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.geomatics;

import com.vividsolutions.jts.geom.Geometry;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.geotoolkit.geometry.jts.JTS;
import org.geotoolkit.gml.GeometrytoJTS;
import org.geotoolkit.gml.xml.AbstractGeometry;
import org.geotoolkit.referencing.CRS;
import org.geotoolkit.xml.MarshallerPool;
import org.opengis.cite.geomatics.GeodesyUtils;
import org.opengis.cite.geomatics.gml.GmlUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.w3c.dom.Node;

public class TopologicalRelationships {
    private static final Logger LOGR = Logger.getLogger(TopologicalRelationships.class.getPackage().getName());

    public static boolean intersects(Node node1, Node node2) throws TransformException {
        Geometry jtsGeom2;
        Geometry jtsGeom1;
        AbstractGeometry gmlGeom2;
        AbstractGeometry gmlGeom1;
        if (!node1.getNamespaceURI().equals("http://www.opengis.net/gml/3.2") || !node2.getNamespaceURI().equals("http://www.opengis.net/gml/3.2")) {
            throw new IllegalArgumentException("Supplied nodes must be in the GML 3.2 namespace http://www.opengis.net/gml/3.2");
        }
        GmlUtils.setSrsNameOnCollectionMembers(node1, node2);
        try {
            MarshallerPool pool = new MarshallerPool("org.geotoolkit.gml.xml.v321");
            Unmarshaller unmarshaller = pool.acquireUnmarshaller();
            JAXBElement result = (JAXBElement)unmarshaller.unmarshal(node1);
            gmlGeom1 = (AbstractGeometry)result.getValue();
            result = (JAXBElement)unmarshaller.unmarshal(node2);
            gmlGeom2 = (AbstractGeometry)result.getValue();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        gmlGeom1.setSrsName(GeodesyUtils.convertSRSNameToURN(gmlGeom1.getSrsName()));
        gmlGeom2.setSrsName(GeodesyUtils.convertSRSNameToURN(gmlGeom2.getSrsName()));
        try {
            jtsGeom1 = GeometrytoJTS.toJTS((AbstractGeometry)gmlGeom1);
            jtsGeom2 = GeometrytoJTS.toJTS((AbstractGeometry)gmlGeom2);
            CoordinateReferenceSystem crs1 = JTS.findCoordinateReferenceSystem((Geometry)jtsGeom1);
            CoordinateReferenceSystem crs2 = JTS.findCoordinateReferenceSystem((Geometry)jtsGeom2);
            if (!crs1.getName().equals(crs2.getName())) {
                if (LOGR.isLoggable(Level.FINE)) {
                    LOGR.fine(String.format("Attempting coordinate transformation from CRS %s to %s", crs1.getName(), crs2.getName()));
                }
                MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)crs1, (CoordinateReferenceSystem)crs2);
                jtsGeom1 = JTS.transform((Geometry)jtsGeom1, (MathTransform)transform);
                JTS.setCRS((Geometry)jtsGeom1, (CoordinateReferenceSystem)crs2);
            }
        }
        catch (FactoryException fe) {
            throw new RuntimeException(fe);
        }
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.fine(String.format("JTS geometry objects:\n  %s\n  %s", jtsGeom1.toText(), jtsGeom2.toText()));
        }
        return jtsGeom1.intersects(jtsGeom2);
    }
}

