/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22.level2;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml22.BaseFixture;
import org.opengis.cite.kml22.ETSAssert;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.util.TestSuiteLogger;
import org.opengis.cite.kml22.util.ValidationUtils;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Recommendations
extends BaseFixture {
    static final String ALT_MODE_CLAMP = "clampToGround";
    static final Set<String> HTTP_QUERY_PARAMS;

    @Test(description="Implements ATC 43")
    public void verifyAltitudeIfNotClampToGround() {
        NodeList nodeList = null;
        try {
            nodeList = XMLUtils.evaluateXPath(this.testSubject, "//kml:coordinates | //kml:Location", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "Error evaluating XPath expression", xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String altitudeMode;
            Element elem = (Element)nodeList.item(i);
            Node altModeNode = null;
            try {
                altModeNode = (Node)XMLUtils.evaluateXPath(elem, "../kml:altitudeMode", NS_MAP, XPathConstants.NODE);
            }
            catch (XPathExpressionException xpe) {
                throw new RuntimeException(xpe);
            }
            String string = altitudeMode = null != altModeNode ? altModeNode.getTextContent().trim() : ALT_MODE_CLAMP;
            if (altitudeMode.equals(ALT_MODE_CLAMP)) continue;
            String localName = elem.getLocalName();
            if (localName.equals("coordinates")) {
                ValidationUtils.validateCoordinateTuples(elem, 3, errHandler);
                continue;
            }
            if (elem.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "altitude").getLength() != 0) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.CoordinatesAltitudeMode.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(elem)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 44")
    public void verifyScale() {
        NodeList scaleNodes = null;
        try {
            scaleNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Scale[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < scaleNodes.getLength(); ++i) {
            Node scale = scaleNodes.item(i);
            try {
                ETSAssert.assertXPath("kml:x or kml:y or kml:z", scale, NS_MAP);
                continue;
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.ScaleMinimal.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(scale)));
            }
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 45")
    public void verifyKmlDocumentIsNotEmpty() {
        Element docElement = this.testSubject.getDocumentElement();
        ETSAssert.assertXPath("kml:*", docElement, NS_MAP);
    }

    @Test(description="Implements ATC 46")
    public void verifyViewFormat() {
        NodeList viewFormatNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "viewFormat");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < viewFormatNodes.getLength(); ++i) {
            Node viewFormat = viewFormatNodes.item(i);
            if (!viewFormat.getTextContent().trim().isEmpty()) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.ViewFormat.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(viewFormat)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 47")
    public void verifyHttpQuery() {
        NodeList queryNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "httpQuery");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        Pattern paramsPattern = Pattern.compile("\\[[a-zA-Z]+\\]");
        HashSet<String> paramSet = new HashSet<String>();
        for (int i = 0; i < queryNodes.getLength(); ++i) {
            paramSet.clear();
            Node queryNode = queryNodes.item(i);
            String queryParams = queryNode.getTextContent().trim();
            if (queryParams.isEmpty()) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.HttpQuery.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(queryNode)));
                continue;
            }
            Matcher paramMatcher = paramsPattern.matcher(queryParams);
            while (paramMatcher.find()) {
                paramSet.add(paramMatcher.group());
            }
            paramSet.retainAll(HTTP_QUERY_PARAMS);
            if (!paramSet.isEmpty()) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.HttpQuery.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(queryNode)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 48")
    public void verifyLinearRing() {
        NodeList ringNodes = null;
        try {
            ringNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:LinearRing[ancestor::kml:Polygon]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < ringNodes.getLength(); ++i) {
            Node ring = ringNodes.item(i);
            try {
                ETSAssert.assertXPath("not(kml:extrude or kml:tessellate or kml:altitudeMode)", ring, NS_MAP);
                continue;
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.LinearRingInPolygon.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(ring)));
            }
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 49")
    public void verifyUntypedData() {
        NodeList dataNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Data");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < dataNodes.getLength(); ++i) {
            Element dataElem = (Element)dataNodes.item(i);
            NodeList valueNodes = dataElem.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "value");
            if (!dataElem.getAttribute("name").isEmpty() && valueNodes.getLength() != 0) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.Data.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(dataElem)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 50")
    public void verifyResourceAliasIsUnique() {
        NodeList resourceMaps = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "ResourceMap");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        HashSet<String> aliasSourceSet = new HashSet<String>();
        for (int i = 0; i < resourceMaps.getLength(); ++i) {
            aliasSourceSet.clear();
            Element resourceMap = (Element)resourceMaps.item(i);
            NodeList aliasNodes = resourceMap.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Alias");
            if (aliasNodes.getLength() == 0) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.ResourceMap.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(resourceMap)));
                continue;
            }
            for (int j = 0; j < aliasNodes.getLength(); ++j) {
                Element alias = (Element)aliasNodes.item(j);
                Node sourceRef = alias.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "sourceHref").item(0);
                String href = sourceRef.getTextContent().trim();
                if (aliasSourceSet.add(href)) continue;
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.ResourceMap.err2", href), new ErrorLocator(-1, -1, XMLUtils.getXPointer(alias)));
            }
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 51")
    public void verifyLinkRefresh() {
        NodeList linkNodes = null;
        try {
            linkNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Link | //kml:Icon", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < linkNodes.getLength(); ++i) {
            Node link = linkNodes.item(i);
            try {
                if (((Boolean)XMLUtils.evaluateXPath(link, "kml:refreshInterval and kml:refreshMode != 'onInterval'", NS_MAP, XPathConstants.BOOLEAN)).booleanValue()) {
                    errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.LinkRefresh.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(link)));
                }
                if (!((Boolean)XMLUtils.evaluateXPath(link, "kml:viewRefreshTime and kml:viewRefreshMode != 'onStop'", NS_MAP, XPathConstants.BOOLEAN)).booleanValue()) continue;
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.LinkRefresh.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(link)));
                continue;
            }
            catch (XPathExpressionException xpe) {
                throw new RuntimeException(xpe);
            }
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 52")
    public void verifyImagePyramidInPhotoOverlay() {
        NodeList overlayNodes = null;
        try {
            overlayNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:PhotoOverlay[kml:Icon or kml:ImagePyramid]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < overlayNodes.getLength(); ++i) {
            boolean hrefParams;
            String href;
            Element photoOverlay = (Element)overlayNodes.item(i);
            try {
                href = (String)XMLUtils.evaluateXPath(photoOverlay, "kml:Icon/kml:href", NS_MAP, XPathConstants.STRING);
            }
            catch (XPathExpressionException e) {
                throw new RuntimeException(e);
            }
            Element pyramid = (Element)photoOverlay.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "ImagePyramid").item(0);
            boolean bl = hrefParams = null != href && href.contains("[level]");
            if (null != pyramid && !hrefParams) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.PhotoOverlay.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(photoOverlay)));
            }
            if (null != pyramid || !hrefParams) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.PhotoOverlay.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(photoOverlay)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 53")
    public void verifyGroundOverlayHasLatLonBox() {
        NodeList overlayNodes = null;
        try {
            overlayNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:GroundOverlay[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < overlayNodes.getLength(); ++i) {
            Node groundOverlay = overlayNodes.item(i);
            try {
                ETSAssert.assertXPath("kml:LatLonBox[kml:north and kml:south and kml:east and kml:west]", groundOverlay, NS_MAP);
                continue;
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.GroundOverlayMinimal.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(groundOverlay)));
            }
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 54")
    public void verifyCamera() {
        NodeList cameraNodes = null;
        try {
            cameraNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Camera[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < cameraNodes.getLength(); ++i) {
            Element camera = (Element)cameraNodes.item(i);
            try {
                ETSAssert.assertXPath("kml:latitude and kml:longitude and kml:altitude", camera, NS_MAP);
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.Camera.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(camera)));
            }
            String altitudeMode = ALT_MODE_CLAMP;
            Node altMode = camera.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "altitudeMode").item(0);
            if (null != altMode) {
                altitudeMode = altMode.getTextContent().trim();
            }
            if (!altitudeMode.equals(ALT_MODE_CLAMP)) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.Camera.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(camera)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 55")
    public void verifyModelLocation() {
        NodeList locationNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Location");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < locationNodes.getLength(); ++i) {
            Node modelAltMode;
            Element location = (Element)locationNodes.item(i);
            try {
                ETSAssert.assertXPath("kml:latitude and kml:longitude", location, NS_MAP);
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.Location.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(location)));
            }
            String altitudeMode = ALT_MODE_CLAMP;
            try {
                modelAltMode = (Node)XMLUtils.evaluateXPath(location, "../kml:altitudeMode", NS_MAP, XPathConstants.NODE);
            }
            catch (XPathExpressionException xpe) {
                throw new RuntimeException(xpe);
            }
            if (null != modelAltMode) {
                altitudeMode = modelAltMode.getTextContent().trim();
            }
            if (altitudeMode.equals(ALT_MODE_CLAMP) || location.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "altitude").getLength() != 0) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.Location.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(location)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 56")
    public void verifyOverlayHasIcon() {
        NodeList overlayNodes = null;
        try {
            overlayNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:ScreenOverlay[not(ancestor::kml:Update)] | //kml:GroundOverlay[not(ancestor::kml:Update)] | //kml:PhotoOverlay[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < overlayNodes.getLength(); ++i) {
            Element overlay = (Element)overlayNodes.item(i);
            if (overlay.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Icon").getLength() != 0) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.Overlay.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(overlay)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 57")
    public void verifyScreenOverlay() {
        NodeList overlayNodes = null;
        try {
            overlayNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:ScreenOverlay[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < overlayNodes.getLength(); ++i) {
            Element screenOverlay = (Element)overlayNodes.item(i);
            if (screenOverlay.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "screenXY").getLength() != 0) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.ScreenOverlay.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(screenOverlay)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 59")
    public void verifyExtendedDataNotEmpty() {
        NodeList extDataNodes = this.testSubject.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "ExtendedData");
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < extDataNodes.getLength(); ++i) {
            Node extData = extDataNodes.item(i);
            if (extData.getChildNodes().getLength() != 0) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.ExtendedData.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(extData)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 60")
    public void verifyFolderNotEmpty() {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        this.verifyElementNotEmpty("Folder", errHandler);
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 62")
    public void verifyImagePyramid() {
        NodeList imgPyramidNodes = null;
        try {
            imgPyramidNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:ImagePyramid[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < imgPyramidNodes.getLength(); ++i) {
            int tileSize;
            Element imgPyramid = (Element)imgPyramidNodes.item(i);
            try {
                ETSAssert.assertXPath("kml:maxWidth and kml:maxHeight", imgPyramid, NS_MAP);
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.ImagePyramid.err1", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(imgPyramid)));
            }
            Node tileSizeNode = imgPyramid.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "tileSize").item(0);
            if (null == tileSizeNode || ((tileSize = Integer.parseInt(tileSizeNode.getTextContent())) & tileSize - 1) == 0) continue;
            errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.ImagePyramid.err2", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(imgPyramid)));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 66")
    public void verifyMultiGeometry() {
        NodeList multiGeomNodes = null;
        try {
            multiGeomNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:MultiGeometry[not(ancestor::kml:Update)]", NS_MAP);
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        for (int i = 0; i < multiGeomNodes.getLength(); ++i) {
            Node multiGeom = multiGeomNodes.item(i);
            try {
                ETSAssert.assertXPath("count(kml:*) > 1", multiGeom, NS_MAP);
                continue;
            }
            catch (AssertionError e) {
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.MultiGeometry.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(multiGeom)));
            }
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    @Test(description="Implements ATC 67")
    public void verifyPlacemarkHasGeometry() {
        NodeList placemarkNodes = null;
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        try {
            placemarkNodes = XMLUtils.evaluateXPath(this.testSubject, "//kml:Placemark[not(ancestor::kml:Update)]", NS_MAP);
            for (int i = 0; i < placemarkNodes.getLength(); ++i) {
                Node placemark = placemarkNodes.item(i);
                NodeList geomList = XMLUtils.evaluateXPath(placemark, "kml:Point | kml:LineString | kml:LinearRing | kml:Polygon | kml:Model | kml:MultiGeometry", NS_MAP);
                if (geomList.getLength() != 0) continue;
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.Placemark.err", new Object[0]), new ErrorLocator(-1, -1, XMLUtils.getXPointer(placemark)));
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)errHandler.toString());
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("[clientVersion]");
        types.add("[kmlVersion]");
        types.add("[clientName]");
        types.add("[language]");
        HTTP_QUERY_PARAMS = Collections.unmodifiableSet(types);
    }
}

