/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.Namespaces;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.SAXException;

public class BasicGetFeatureTests
extends BaseFixture {
    private static final QName FEATURE_COLL = new QName("http://www.opengis.net/wfs/2.0", "FeatureCollection");
    Validator hintsValidator;

    @BeforeClass
    public void buildValidator() {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        try {
            Schema schema = factory.newSchema();
            this.hintsValidator = schema.newValidator();
            LSResourceResolver resolver = ValidationUtils.createSchemaResolver(Namespaces.XSD);
            this.hintsValidator.setResourceResolver(resolver);
        }
        catch (SAXException e) {
            TestSuiteLogger.log(Level.WARNING, "Failed to build XML Schema Validator that heeds location hints.", e);
        }
    }

    @BeforeMethod
    public void buildRequestEntity() {
        String resourceName = "GetFeature-Minimal.xml";
        try {
            this.reqEntity = this.docBuilder.parse(this.getClass().getResourceAsStream(resourceName));
        }
        catch (Exception x) {
            TestSuiteLogger.log(Level.WARNING, "Failed to parse request entity from classpath: " + resourceName, x);
        }
    }

    @AfterMethod
    public void resetValidator() {
        this.hintsValidator.reset();
    }

    @Test(description="See ISO 19142: 11.2.2, 11.2.3", dataProvider="all-protocols-featureTypes")
    public void getFeaturesByType(ProtocolBinding binding, QName featureType) {
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetFeature", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new DOMSource(this.reqEntity), binding, endpoint);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Document entity = this.extractBodyAsDocument(rsp, binding);
        ETSAssert.assertQualifiedName(entity.getDocumentElement(), FEATURE_COLL);
        ETSAssert.assertSchemaValid(this.hintsValidator, new DOMSource(entity.getDocumentElement(), entity.getDocumentURI()));
    }

    void setFeatureAvailability(FeatureTypeInfo featureInfo, Document entity) {
        QName typeName = featureInfo.getTypeName();
        NodeList features = entity.getElementsByTagNameNS(typeName.getNamespaceURI(), typeName.getLocalPart());
        featureInfo.setInstantiated(features.getLength() > 0);
    }
}

