/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.LoggingFilter;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriBuilder;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.util.SOAPMessageConsumer;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WFSClient {
    private static final Logger LOGR = Logger.getLogger(WFSClient.class.getPackage().getName());
    protected Client client;
    protected Document wfsMetadata;
    protected Set<ProtocolBinding> globalBindings;
    protected List<QName> featureTypes;

    public WFSClient() {
        DefaultClientConfig config = new DefaultClientConfig();
        config.getClasses().add(SOAPMessageConsumer.class);
        this.client = Client.create((ClientConfig)config);
        this.client.addFilter((ClientFilter)new LoggingFilter());
    }

    public WFSClient(Document wfsMetadata) {
        this();
        this.wfsMetadata = wfsMetadata;
        this.featureTypes = ServiceMetadataUtils.getFeatureTypes(wfsMetadata);
        this.globalBindings = ServiceMetadataUtils.getGlobalBindings(wfsMetadata);
    }

    public Document getServiceDescription() {
        return this.wfsMetadata;
    }

    public void setServiceDescription(InputStream srvMetadata) throws SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document doc = docBuilder.parse(srvMetadata);
            if (doc.getDocumentElement().getLocalName().equals("WFS_Capabilities")) {
                this.wfsMetadata = docBuilder.parse(srvMetadata);
            }
        }
        catch (ParserConfigurationException e) {
            LOGR.log(Level.WARNING, e.getMessage());
        }
    }

    public Document invokeStoredQuery(String queryId, Map<String, Object> params) {
        Document req = WFSRequest.createRequestEntity("GetFeature");
        WFSRequest.appendStoredQuery(req, queryId, params);
        ProtocolBinding binding = this.globalBindings.iterator().next();
        return this.retrieveXMLResponseEntity(req, binding);
    }

    public Document getFeatureByType(QName typeName, int count, ProtocolBinding binding) {
        if (null == binding) {
            binding = this.globalBindings.iterator().next();
        }
        Document req = WFSRequest.createRequestEntity("GetFeature");
        if (count > 0) {
            req.getDocumentElement().setAttribute("count", Integer.toString(count));
        }
        WFSRequest.appendSimpleQuery(req, typeName);
        return this.retrieveXMLResponseEntity(req, binding);
    }

    public Document delete(Map<String, QName> features, ProtocolBinding binding) {
        Document req = WFSRequest.createRequestEntity("Transaction");
        for (Map.Entry<String, QName> entry : features.entrySet()) {
            QName typeName = entry.getValue();
            Element delete = req.createElementNS("http://www.opengis.net/wfs/2.0", "Delete");
            delete.setPrefix("wfs");
            delete.setAttribute("xmlns:tns", typeName.getNamespaceURI());
            delete.setAttribute("typeName", "tns:" + typeName.getLocalPart());
            req.getDocumentElement().appendChild(delete);
            Element filter = req.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
            delete.appendChild(filter);
            Element resourceId = req.createElementNS("http://www.opengis.net/fes/2.0", "ResourceId");
            resourceId.setAttribute("rid", entry.getKey());
            filter.appendChild(resourceId);
        }
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            TestSuiteLogger.log(Level.FINE, XMLUtils.writeNodeToString(req));
        }
        return this.executeTransaction(req, binding);
    }

    public Document insert(List<Element> features, ProtocolBinding binding) {
        if (features.isEmpty()) {
            throw new IllegalArgumentException("No features instances to insert.");
        }
        Document req = WFSRequest.createRequestEntity("Transaction");
        Element insert = req.createElementNS("http://www.opengis.net/wfs/2.0", "Insert");
        insert.setPrefix("wfs");
        req.getDocumentElement().appendChild(insert);
        for (Element feature : features) {
            insert.appendChild(req.importNode(feature, true));
        }
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            TestSuiteLogger.log(Level.FINE, XMLUtils.writeNodeToString(req));
        }
        return this.executeTransaction(req, binding);
    }

    public Document updateFeature(String id, QName featureType, Map<String, Object> properties) {
        Document req = WFSRequest.createRequestEntity("Transaction");
        return this.updateFeature(req, id, featureType, properties, ProtocolBinding.POST);
    }

    public Document updateFeature(Document req, String id, QName featureType, Map<String, Object> properties, ProtocolBinding binding) {
        Element update = req.createElementNS("http://www.opengis.net/wfs/2.0", "Update");
        update.setPrefix("wfs");
        req.getDocumentElement().appendChild(update);
        WFSRequest.setTypeName(update, featureType);
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            Element prop = req.createElementNS("http://www.opengis.net/wfs/2.0", "Property");
            prop.setPrefix("wfs");
            Element valueRef = req.createElementNS("http://www.opengis.net/wfs/2.0", "ValueReference");
            valueRef.setTextContent(property.getKey());
            valueRef.setPrefix("wfs");
            prop.appendChild(valueRef);
            Element value = req.createElementNS("http://www.opengis.net/wfs/2.0", "Value");
            value.setPrefix("wfs");
            if (Node.class.isInstance(property.getValue())) {
                value.appendChild((Node)property.getValue());
            } else {
                value.setTextContent(property.getValue().toString());
            }
            prop.appendChild(value);
            update.appendChild(prop);
        }
        Element filter = WFSRequest.newResourceIdFilter(id);
        update.appendChild(req.adoptNode(filter));
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            TestSuiteLogger.log(Level.FINE, XMLUtils.writeNodeToString(req));
        }
        return this.executeTransaction(req, binding);
    }

    public ClientResponse submitRequest(Source entity, ProtocolBinding binding, URI endpoint) {
        WebResource resource = this.client.resource(endpoint);
        WebResource.Builder builder = resource.accept(new MediaType[]{MediaType.APPLICATION_XML_TYPE, MediaType.valueOf((String)"application/soap+xml")});
        LOGR.log(Level.FINE, String.format("Submitting %s request to URI %s", new Object[]{binding, resource.getURI()}));
        ClientResponse response = null;
        switch (binding) {
            case GET: {
                String queryString = WFSRequest.transformEntityToKVP(entity);
                URI requestURI = UriBuilder.fromUri((URI)resource.getURI()).replaceQuery(queryString).build(new Object[0]);
                LOGR.log(Level.FINE, String.format("Request URI: %s", requestURI));
                resource = resource.uri(requestURI);
                response = (ClientResponse)resource.get(ClientResponse.class);
                break;
            }
            case POST: {
                response = (ClientResponse)((WebResource.Builder)builder.type(MediaType.APPLICATION_XML_TYPE)).post(ClientResponse.class, (Object)entity);
                break;
            }
            case SOAP: {
                Document soapEnv = WFSRequest.wrapEntityInSOAPEnvelope(entity, "1.1");
                response = (ClientResponse)((WebResource.Builder)builder.type(MediaType.valueOf((String)"application/soap+xml"))).post(ClientResponse.class, (Object)new DOMSource(soapEnv));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported message binding: " + (Object)((Object)binding));
            }
        }
        return response;
    }

    public ClientResponse submitRequest(Document reqEntity, ProtocolBinding binding) {
        String requestName = reqEntity.getDocumentElement().getLocalName();
        Map<String, URI> endpoints = ServiceMetadataUtils.getRequestEndpoints(this.wfsMetadata, requestName);
        if (null == endpoints) {
            throw new IllegalArgumentException("No HTTP method bindings found for " + requestName);
        }
        if (null == binding || binding.equals((Object)ProtocolBinding.ANY)) {
            String methodName = endpoints.keySet().iterator().next();
            binding = Enum.valueOf(ProtocolBinding.class, methodName);
        }
        String httpMethod = binding == ProtocolBinding.SOAP ? ProtocolBinding.POST.name() : binding.name();
        return this.submitRequest(new DOMSource(reqEntity), binding, endpoints.get(httpMethod));
    }

    public Document getCapabilities() {
        if (null == this.wfsMetadata) {
            throw new IllegalStateException("Service description is unavailable.");
        }
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetCapabilities", ProtocolBinding.GET);
        WebResource resource = this.client.resource(endpoint);
        MultivaluedMapImpl queryParams = new MultivaluedMapImpl();
        queryParams.add((Object)"request", (Object)"GetCapabilities");
        queryParams.add((Object)"service", (Object)"WFS");
        queryParams.add((Object)"version", (Object)"2.0.0");
        return (Document)resource.queryParams((MultivaluedMap)queryParams).get(Document.class);
    }

    public ProtocolBinding getAnyTransactionBinding() {
        Set<ProtocolBinding> trxBindings = ServiceMetadataUtils.getOperationBindings(this.wfsMetadata, "Transaction");
        return trxBindings.iterator().next();
    }

    Document executeTransaction(Document request, ProtocolBinding binding) {
        URI endpoint;
        if (binding == ProtocolBinding.ANY) {
            binding = this.getAnyTransactionBinding();
        }
        if (null == (endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "Transaction", binding)).getScheme()) {
            throw new IllegalArgumentException("No Transaction endpoint found for binding " + (Object)((Object)binding));
        }
        LOGR.log(Level.FINE, String.format("Submitting request entity to URI %s \n%s", endpoint, XMLUtils.writeNodeToString(request)));
        ClientResponse rsp = this.submitRequest(new DOMSource(request), binding, endpoint);
        Document entity = null;
        if (rsp.hasEntity()) {
            entity = (Document)rsp.getEntity(Document.class);
        }
        return entity;
    }

    Document retrieveXMLResponseEntity(Document request, ProtocolBinding binding) {
        if (LOGR.isLoggable(Level.FINE)) {
            LOGR.fine("Request entity:\n" + XMLUtils.writeNodeToString(request));
        }
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, request.getDocumentElement().getLocalName(), binding);
        ClientResponse rsp = this.submitRequest(new DOMSource(request), binding, endpoint);
        Document rspEntity = null;
        if (rsp.hasEntity()) {
            MediaType mediaType = rsp.getType();
            if (!mediaType.getSubtype().endsWith("xml")) {
                throw new RuntimeException("Did not receive an XML entity: " + mediaType);
            }
            rspEntity = (Document)rsp.getEntity(Document.class);
            if (LOGR.isLoggable(Level.FINE)) {
                LOGR.fine("Response entity:\n" + XMLUtils.writeNodeToString(rspEntity));
            }
        }
        return rspEntity;
    }
}

