/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30;

import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.opengis.cite.cat30.CommonFixture;
import org.opengis.cite.cat30.util.ClientUtils;
import org.opengis.cite.cat30.util.XMLUtils;
import org.testng.ITestResult;
import org.testng.TestListenerAdapter;
import org.w3c.dom.Document;

public class TestFailureListener
extends TestListenerAdapter {
    public void onTestFailure(ITestResult result) {
        super.onTestFailure(result);
        Object instance = result.getInstance();
        if (CommonFixture.class.isInstance(instance)) {
            CommonFixture fixture = (CommonFixture)CommonFixture.class.cast(instance);
            result.setAttribute("request", (Object)this.getRequestMessageInfo(fixture.request));
            result.setAttribute("response", (Object)this.getResponseMessageInfo(fixture.response));
        }
    }

    String getRequestMessageInfo(ClientRequest req) {
        if (null == req) {
            return "No request message.";
        }
        StringBuilder msgInfo = new StringBuilder();
        msgInfo.append("Method: ").append(req.getMethod()).append('\n');
        msgInfo.append("Target URI: ").append(req.getURI()).append('\n');
        msgInfo.append("Headers: ").append(req.getHeaders()).append('\n');
        if (null != req.getEntity()) {
            String body;
            Object entity = req.getEntity();
            if (Document.class.isInstance(entity)) {
                Document doc = (Document)Document.class.cast(entity);
                body = XMLUtils.writeNodeToString(doc);
            } else {
                body = entity.toString();
            }
            msgInfo.append(body).append('\n');
        }
        return msgInfo.toString();
    }

    String getResponseMessageInfo(ClientResponse rsp) {
        if (null == rsp) {
            return "No response message.";
        }
        StringBuilder msgInfo = new StringBuilder();
        msgInfo.append("Status: ").append(rsp.getStatus()).append('\n');
        msgInfo.append("Headers: ").append(rsp.getHeaders()).append('\n');
        if (rsp.hasEntity()) {
            try {
                rsp.getEntityInputStream().reset();
            }
            catch (IOException ex) {
                Logger.getLogger(TestFailureListener.class.getName()).log(Level.WARNING, "Failed to reset entity InputStream", ex);
            }
            if (XMLUtils.isXML(rsp.getType())) {
                Document doc = ClientUtils.getResponseEntityAsDocument(rsp, null);
                if (null == doc) {
                    msgInfo.append("Failed to parse XML response entity.");
                } else {
                    msgInfo.append(XMLUtils.writeNodeToString(doc));
                }
            } else {
                byte[] body = (byte[])rsp.getEntity(byte[].class);
                msgInfo.append(new String(body, StandardCharsets.US_ASCII));
            }
            msgInfo.append('\n');
        }
        return msgInfo.toString();
    }
}

