/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.cat30.opensearch.TemplateParamInfo;
import org.opengis.cite.cat30.util.NamespaceBindings;
import org.opengis.cite.cat30.util.OpenSearchTemplateUtils;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.opengis.cite.cat30.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServiceMetadataUtils {
    public static final String URL_TEMPLATE_PARAMS = "url.template.params";

    public static URI getOperationEndpoint(Document cswMetadata, String opName, String httpMethod) {
        String expr;
        if (null == httpMethod || httpMethod.isEmpty()) {
            expr = String.format("//ows:Operation[@name='%s']//ows:HTTP/*[1]/@xlink:href", opName);
        } else {
            StringBuilder method = new StringBuilder(httpMethod);
            method.replace(1, method.length(), method.substring(1).toLowerCase());
            expr = String.format("//ows:Operation[@name='%s']//ows:%s/@xlink:href", opName, method.toString());
        }
        NamespaceBindings nsBindings = new NamespaceBindings();
        nsBindings.addNamespaceBinding("http://www.opengis.net/ows/2.0", "ows");
        nsBindings.addNamespaceBinding("http://www.w3.org/1999/xlink", "xlink");
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(nsBindings);
        URI endpoint = null;
        try {
            String href = xpath.evaluate(expr, cswMetadata);
            endpoint = URI.create(href);
        }
        catch (XPathExpressionException ex) {
            TestSuiteLogger.log(Level.INFO, ex.getMessage());
        }
        if (null != endpoint && null != endpoint.getQuery()) {
            String uriRef = endpoint.toString();
            endpoint = URI.create(uriRef.substring(0, uriRef.indexOf(63)));
        }
        return endpoint;
    }

    public static List<Node> getOpenSearchURLTemplates(Document osDescr) {
        ArrayList<Node> urlList = new ArrayList<Node>();
        NodeList nodes = osDescr.getElementsByTagNameNS("http://a9.com/-/spec/opensearch/1.1/", "Url");
        Pattern queryParam = Pattern.compile("\\{([^}]+)\\}");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element urlElem = (Element)nodes.item(i);
            String template = urlElem.getAttribute("template");
            Matcher matcher = queryParam.matcher(template);
            ArrayList<TemplateParamInfo> templateParamList = new ArrayList<TemplateParamInfo>();
            while (matcher.find()) {
                TemplateParamInfo paramInfo = new TemplateParamInfo();
                String param = matcher.group(1);
                paramInfo.setIsRequired(!param.endsWith("?"));
                QName paramQName = OpenSearchTemplateUtils.getTemplateParameterName(param, urlElem);
                paramInfo.setName(paramQName);
                templateParamList.add(paramInfo);
                if (!paramQName.getNamespaceURI().equals("http://a9.com/-/spec/opensearch/1.1/")) continue;
                OpenSearchTemplateUtils.updateOpenSearchParameter(paramInfo, urlElem);
            }
            urlElem.setUserData(URL_TEMPLATE_PARAMS, Collections.unmodifiableList(templateParamList), null);
            urlList.add(urlElem);
        }
        return urlList;
    }

    public static List<Node> getOpenSearchQueriesByRole(Document osDescr, QName role) {
        ArrayList<Node> queryList = new ArrayList<Node>();
        NodeList nodes = osDescr.getElementsByTagNameNS("http://a9.com/-/spec/opensearch/1.1/", "Query");
        for (int i = 0; i < nodes.getLength(); ++i) {
            Element query = (Element)nodes.item(i);
            QName roleName = OpenSearchTemplateUtils.getTemplateParameterName(query.getAttribute("role"), query);
            if (!roleName.equals(role)) continue;
            queryList.add(query);
        }
        return queryList;
    }

    public static Set<String> getConstraintValues(Document cswMetadata, String name) {
        HashSet<String> valueList = new HashSet<String>();
        String xpath = String.format("//ows:Constraint[matches(@name,'%s','i')]", name);
        try {
            XdmValue result = XMLUtils.evaluateXPath2(new DOMSource(cswMetadata), xpath, Collections.singletonMap("http://www.opengis.net/ows/2.0", "ows"));
            ServiceMetadataUtils.addDomainValues(valueList, result);
        }
        catch (SaxonApiException ex) {
            // empty catch block
        }
        return valueList;
    }

    public static Set<String> getParameterValues(Document cswMetadata, String reqName, String paramName) {
        HashSet<String> valueSet = new HashSet<String>();
        String xpath = String.format("//ows:OperationsMetadata/ows:Parameter[matches(@name,'%s','i')]", paramName);
        Map<String, String> nsBindings = Collections.singletonMap("http://www.opengis.net/ows/2.0", "ows");
        try {
            XdmValue result = XMLUtils.evaluateXPath2(new DOMSource(cswMetadata), xpath, nsBindings);
            ServiceMetadataUtils.addDomainValues(valueSet, result);
            if (null != reqName) {
                xpath = String.format("//ows:Operation[@name='%s']/ows:Parameter[matches(@name,'%s','i')]", reqName, paramName);
                result = XMLUtils.evaluateXPath2(new DOMSource(cswMetadata), xpath, nsBindings);
                ServiceMetadataUtils.addDomainValues(valueSet, result);
            }
        }
        catch (SaxonApiException ex) {
            // empty catch block
        }
        return valueSet;
    }

    static void addDomainValues(Set<String> valueSet, XdmValue opMetadata) {
        if (null == opMetadata) {
            return;
        }
        if (null == valueSet) {
            valueSet = new HashSet<String>();
        }
        QName defaultValue = new QName("http://www.opengis.net/ows/2.0", "DefaultValue");
        QName value = new QName("http://www.opengis.net/ows/2.0", "Value");
        for (XdmItem item : opMetadata) {
            XdmNode node = (XdmNode)item;
            XdmSequenceIterator nodes = node.axisIterator(Axis.DESCENDANT, new net.sf.saxon.s9api.QName(defaultValue));
            if (!nodes.hasNext()) {
                nodes = node.axisIterator(Axis.DESCENDANT, new net.sf.saxon.s9api.QName(value));
            }
            while (nodes.hasNext()) {
                valueSet.add(nodes.next().getStringValue().trim());
            }
        }
    }
}

