/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml2.CommonFixture;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.SuiteAttribute;
import org.opengis.cite.kml2.util.URIUtils;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.ExtendedDataValidator;
import org.opengis.cite.kml2.validation.RegionValidator;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CommonFeatureTests
extends CommonFixture {
    private Set<String> sharedStyles;
    private RegionValidator regionValidator;

    public CommonFeatureTests() {
        this.regionValidator = new RegionValidator(this.conformanceLevel);
    }

    @BeforeClass
    public void getSharedStyles(ITestContext testContext) {
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.SHARED_STYLES.getName());
        if (null != obj) {
            this.sharedStyles = (Set)obj;
        }
    }

    @Test(description="ATC-106")
    public void validStyleReference() {
        if (null == this.targetElements) {
            return;
        }
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Node referent;
            Element kmlFeature = (Element)this.targetElements.item(i);
            NodeList styleUrlElem = kmlFeature.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "styleUrl");
            if (styleUrlElem.getLength() == 0) continue;
            URI styleUrl = URI.create(styleUrlElem.item(0).getTextContent().trim());
            if (styleUrl.getPath().isEmpty()) {
                String id = styleUrl.getFragment();
                Assert.assertTrue((boolean)this.sharedStyles.contains(id), (String)ErrorMessage.format("SharedStyleNotFound", id));
                continue;
            }
            styleUrl = URIUtils.resolveRelativeURI(this.kmlDoc.getDocumentURI(), styleUrl.toString());
            try {
                referent = URIUtils.parseURI(styleUrl);
            }
            catch (IOException | SAXException e) {
                throw new AssertionError((Object)ErrorMessage.format("XMLError", styleUrl));
            }
            Assert.assertNotNull((Object)referent, (String)ErrorMessage.format("SharedStyleNotFound", styleUrl));
            ETSAssert.assertQualifiedName(referent, new QName("http://www.opengis.net/kml/2.2", "Style"), new QName("http://www.opengis.net/kml/2.2", "StyleMap"));
        }
    }

    @Test(description="ATC-108, ATC-111")
    public void validRegion() {
        if (null == this.targetElements) {
            return;
        }
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element kmlFeature = (Element)this.targetElements.item(i);
            NodeList region = kmlFeature.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Region");
            if (region.getLength() == 0) continue;
            Assert.assertTrue((boolean)this.regionValidator.isValid(region.item(0)), (String)this.regionValidator.getErrorMessages());
        }
    }

    @Test(description="ATC-137, ATC-213")
    public void validViewpoint() {
        if (null == this.targetElements || this.conformanceLevel == 1) {
            return;
        }
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element kmlFeature = (Element)this.targetElements.item(i);
            NodeList view = null;
            try {
                view = XMLUtils.evaluateXPath(kmlFeature, "kml:Camera | kml:LookAt", null);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
            if (view.getLength() <= 0) continue;
            String phase = this.conformanceLevel == 1 ? "MainPhase" : "#ALL";
            URL schRef = this.getClass().getResource("/org/opengis/cite/kml2/sch/kml-viewpoint.sch");
            ETSAssert.assertSchematronValid(schRef, new DOMSource(view.item(0)), phase);
        }
    }

    @Test(description="ATC-127")
    public void validExtendedData() {
        if (null == this.targetElements) {
            return;
        }
        ExtendedDataValidator validator = new ExtendedDataValidator();
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element kmlFeature = (Element)this.targetElements.item(i);
            Node extData = kmlFeature.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "ExtendedData").item(0);
            if (null == extData) continue;
            Assert.assertTrue((boolean)validator.isValid(extData), (String)validator.getErrorMessages());
        }
    }

    @Test(description="ATC-124")
    public void phoneNumber() {
        if (null == this.targetElements) {
            return;
        }
        Pattern phoneNumPattern = Pattern.compile("tel:(\\+)?(\\d*([-.()])?)+(\\d{3}?[-.()])?(\\d{3}[-.()])?(\\d{4,10})?([;].*)?");
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element kmlFeature = (Element)this.targetElements.item(i);
            Node phoneNum = kmlFeature.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "phoneNumber").item(0);
            if (null == phoneNum) continue;
            Matcher matcher = phoneNumPattern.matcher(phoneNum.getTextContent());
            Assert.assertTrue((boolean)matcher.matches(), (String)ErrorMessage.format("ConstraintViolation", "Valid 'tel' URI (RFC 3966)", XMLUtils.buildXPointer(phoneNum)));
        }
    }

    @Test(description="ATC-130")
    public void atomAuthor() {
        if (null == this.targetElements) {
            return;
        }
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element kmlFeature = (Element)this.targetElements.item(i);
            try {
                Node email;
                Node uri = XMLUtils.evaluateXPath(kmlFeature, "atom:author/atom:uri", null).item(0);
                if (null != uri) {
                    ETSAssert.assertValidIRI(uri.getTextContent().trim());
                }
                if (null == (email = XMLUtils.evaluateXPath(kmlFeature, "atom:author/atom:email", null).item(0))) continue;
                ETSAssert.assertValidEmailAddress(email.getTextContent().trim());
                continue;
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
        }
    }

    @Test(description="ATC-135, ATC-232")
    public void checkFeatureConstraints() {
        if (null == this.targetElements) {
            return;
        }
        URL schRef = this.getClass().getResource("/org/opengis/cite/kml2/sch/kml-feature.sch");
        String activePhase = this.conformanceLevel > 1 ? "CL2" : "MainPhase";
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element kmlFeature = (Element)this.targetElements.item(i);
            ETSAssert.assertSchematronValid(schRef, new DOMSource(kmlFeature), activePhase);
        }
    }
}

