/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import net.sf.saxon.value.BooleanValue;
import org.apache.jena.iri.IRI;
import org.apache.jena.iri.IRIException;
import org.apache.jena.iri.IRIFactory;
import org.opengis.cite.kml2.AltitudeMode;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.HttpClientUtils;
import org.opengis.cite.kml2.util.KMLUtils;
import org.opengis.cite.kml2.util.NamespaceBindings;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;

public class ETSAssert {
    private static final Logger LOGR = Logger.getLogger(ETSAssert.class.getPackage().getName());

    private ETSAssert() {
    }

    public static void assertQualifiedName(Node node, QName ... expectedNames) {
        QName nodeName = XMLUtils.getQName(node);
        boolean match = false;
        for (QName qName : expectedNames) {
            if (!nodeName.equals(qName)) continue;
            match = true;
            break;
        }
        Assert.assertTrue((boolean)match, (String)ErrorMessage.format("UnexpectedQName", nodeName, Arrays.toString(expectedNames)));
    }

    public static void assertXPath(String expr, Node context, Map<String, String> namespaceBindings) {
        Boolean result;
        if (null == context) {
            throw new NullPointerException("Context node is null.");
        }
        NamespaceBindings bindings = NamespaceBindings.withStandardBindings();
        bindings.addAllBindings(namespaceBindings);
        XPath xpath = XPathFactory.newInstance().newXPath();
        xpath.setNamespaceContext(bindings);
        try {
            result = (Boolean)xpath.evaluate(expr, context, XPathConstants.BOOLEAN);
        }
        catch (XPathExpressionException xpe) {
            String msg = ErrorMessage.format("XPathError", expr);
            LOGR.log(Level.WARNING, msg, xpe);
            throw new AssertionError((Object)msg);
        }
        Element elemNode = Document.class.isInstance(context) ? ((Document)Document.class.cast(context)).getDocumentElement() : (Element)context;
        Assert.assertTrue((boolean)result, (String)ErrorMessage.format("XPathResult", elemNode.getNodeName(), expr));
    }

    public static void assertSchemaValid(Validator validator, Source source) {
        ValidationErrorHandler errHandler = new ValidationErrorHandler();
        validator.setErrorHandler((ErrorHandler)errHandler);
        try {
            validator.validate(source);
        }
        catch (Exception e) {
            throw new AssertionError((Object)ErrorMessage.format("XMLError", e.getMessage()));
        }
        Assert.assertFalse((boolean)errHandler.errorsDetected(), (String)ErrorMessage.format("NotSchemaValid", errHandler.getErrorCount(), errHandler.toString()));
    }

    public static void assertSchematronValid(URL schemaRef, Source xmlSource) {
        ETSAssert.assertSchematronValid(schemaRef, xmlSource, "#ALL");
    }

    public static void assertSchematronValid(URL schemaRef, Source xmlSource, String activePhase) {
        SchematronValidator validator;
        String phase = null == activePhase || activePhase.isEmpty() ? "#ALL" : activePhase;
        try {
            validator = new SchematronValidator((Source)new StreamSource(schemaRef.toString()), phase);
        }
        catch (Exception e) {
            StringBuilder msg = new StringBuilder("Failed to process Schematron schema at ");
            msg.append(schemaRef).append('\n');
            msg.append(e.getMessage());
            throw new AssertionError(msg);
        }
        DOMResult result = validator.validate(xmlSource);
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }

    public static void assertDescendantElementCount(Node node, QName elementName, int expectedCount) {
        Element contextElem;
        switch (node.getNodeType()) {
            case 9: {
                contextElem = ((Document)Document.class.cast(node)).getDocumentElement();
                break;
            }
            case 1: {
                contextElem = (Element)Element.class.cast(node);
                break;
            }
            default: {
                return;
            }
        }
        NodeList descendants = contextElem.getElementsByTagNameNS(elementName.getNamespaceURI(), elementName.getLocalPart());
        Assert.assertEquals((int)descendants.getLength(), (int)expectedCount, (String)String.format("Unexpected number of %s descendant elements.", elementName));
    }

    public static void assertValidAltitudeMode(Element kmlElement) {
        boolean tessellate = false;
        Node tessellateNode = kmlElement.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "tessellate").item(0);
        if (null != tessellateNode) {
            BooleanValue bool = (BooleanValue)BooleanValue.fromString((CharSequence)tessellateNode.getTextContent());
            tessellate = bool.getBooleanValue();
        }
        boolean extrude = false;
        Node extrudeNode = kmlElement.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "extrude").item(0);
        if (null != extrudeNode) {
            BooleanValue bool = (BooleanValue)BooleanValue.fromString((CharSequence)extrudeNode.getTextContent());
            extrude = bool.getBooleanValue();
        }
        Assert.assertTrue((!tessellate || !extrude ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintViolation", "kml:tessellate and kml:extrude cannot both be true.", XMLUtils.buildXPointer(kmlElement)));
        AltitudeMode altMode = KMLUtils.getAltitudeMode(kmlElement);
        Assert.assertTrue((!tessellate || altMode.equals((Object)AltitudeMode.CLAMP_TO_GROUND) ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintViolation", "kml:altitudeMode = 'clampToGround' when kml:tessellate is true.", XMLUtils.buildXPointer(kmlElement)));
        Assert.assertTrue((!extrude || !altMode.equals((Object)AltitudeMode.CLAMP_TO_GROUND) ? 1 : 0) != 0, (String)ErrorMessage.format("ConstraintViolation", "kml:altitudeMode is not 'clampToGround' when kml:extrude is true.", XMLUtils.buildXPointer(kmlElement)));
    }

    public static void assertReferentExists(URI uri, MediaType ... acceptableTypes) {
        if (!uri.isAbsolute()) {
            throw new AssertionError((Object)ErrorMessage.format("URINotAccessible", uri, "The URI is not absolute"));
        }
        if (null == acceptableTypes || acceptableTypes.length == 0) {
            acceptableTypes = new MediaType[]{MediaType.WILDCARD_TYPE};
        }
        try {
            URLConnection urlConn = uri.toURL().openConnection();
            switch (uri.getScheme().toLowerCase()) {
                case "file": {
                    InputStream inStream = urlConn.getInputStream();
                    Throwable throwable = null;
                    if (inStream != null) {
                        if (throwable != null) {
                            try {
                                inStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            break;
                        }
                        inStream.close();
                    }
                    break;
                }
                case "https": 
                case "http": {
                    HttpURLConnection httpConn = (HttpURLConnection)urlConn;
                    httpConn.setRequestMethod("HEAD");
                    httpConn.setConnectTimeout(5000);
                    StringBuilder acceptHeaderVal = new StringBuilder();
                    for (MediaType type : acceptableTypes) {
                        acceptHeaderVal.append(type).append(',');
                    }
                    httpConn.setRequestProperty("Accept", acceptHeaderVal.toString());
                    if (httpConn.getResponseCode() != 200) {
                        throw new AssertionError((Object)ErrorMessage.format("UnexpectedStatus", uri));
                    }
                    String contentType = urlConn.getContentType();
                    if (!HttpClientUtils.contentIsAcceptable(contentType, acceptableTypes)) {
                        throw new AssertionError((Object)ErrorMessage.format("UnacceptableMediaType", contentType, Arrays.toString(acceptableTypes)));
                    }
                    break;
                }
                default: {
                    throw new AssertionError((Object)ErrorMessage.format("URINotAccessible", uri, "Unsupported URI scheme."));
                }
            }
        }
        catch (IOException e) {
            throw new AssertionError((Object)ErrorMessage.format("URINotAccessible", uri, e.getMessage()));
        }
    }

    public static void assertValidEmailAddress(String emailAddr) {
        Pattern emailPattern = Pattern.compile("(.+)@(.+)\\.(.+)");
        Matcher matcher = emailPattern.matcher(emailAddr);
        if (!matcher.matches()) {
            throw new AssertionError((Object)ErrorMessage.format("InvalidEmailAddr", emailAddr));
        }
    }

    public static void assertValidIRI(String id) {
        try {
            IRI iRI = IRIFactory.iriImplementation().construct(id);
        }
        catch (IRIException e) {
            throw new AssertionError((Object)ErrorMessage.format("InvalidIRI", id));
        }
    }
}

