/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2;

import com.sun.jersey.api.client.Client;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.validation.Schema;
import org.opengis.cite.kml2.SuiteAttribute;
import org.opengis.cite.kml2.TestRunArg;
import org.opengis.cite.kml2.util.HttpClientUtils;
import org.opengis.cite.kml2.util.KMLUtils;
import org.opengis.cite.kml2.util.TestSuiteLogger;
import org.opengis.cite.kml2.util.URIUtils;
import org.opengis.cite.kml2.util.ValidationUtils;
import org.opengis.cite.kml2.util.XMLUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class SuiteFixtureListener
implements ISuiteListener {
    public void onStart(ISuite suite) {
        this.processSuiteParameters(suite);
        this.buildKMLSchemas(suite);
        this.registerHttpClient(suite);
    }

    void buildKMLSchemas(ISuite suite) {
        Schema kml23Schema;
        Schema kml22Schema = ValidationUtils.createKMLSchema("2.2");
        if (null != kml22Schema) {
            suite.setAttribute(SuiteAttribute.KML22_SCHEMA.getName(), (Object)kml22Schema);
        }
        if (null != (kml23Schema = ValidationUtils.createKMLSchema("2.3"))) {
            suite.setAttribute(SuiteAttribute.KML23_SCHEMA.getName(), (Object)kml23Schema);
        }
    }

    public void onFinish(ISuite suite) {
    }

    void processSuiteParameters(ISuite suite) {
        Document kmlDoc;
        Map params = suite.getXmlSuite().getParameters();
        TestSuiteLogger.log(Level.CONFIG, "Suite parameters\n" + params.toString());
        Integer level = new Integer(1);
        if (null != params.get(TestRunArg.LVL.toString())) {
            try {
                int lvlParam = Integer.parseInt((String)params.get(TestRunArg.LVL.toString()));
                if (lvlParam > 0 && lvlParam < 4) {
                    level = lvlParam;
                }
            }
            catch (NumberFormatException lvlParam) {
                // empty catch block
            }
        }
        suite.setAttribute(SuiteAttribute.LEVEL.getName(), (Object)level);
        String kmlParam = (String)params.get(TestRunArg.KML.toString());
        if (null == kmlParam || kmlParam.isEmpty()) {
            throw new IllegalArgumentException("Required test run parameter not found: " + TestRunArg.KML.toString());
        }
        URI iutRef = URI.create(kmlParam.trim());
        File entityFile = null;
        try {
            entityFile = URIUtils.dereferenceURI(iutRef);
        }
        catch (IOException iox) {
            throw new RuntimeException("Failed to dereference resource located at " + iutRef, iox);
        }
        try {
            kmlDoc = KMLUtils.parseKMLDocument(entityFile);
        }
        catch (IOException | SAXException x) {
            throw new RuntimeException("Failed to parse KML resource at " + iutRef, x);
        }
        suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), (Object)kmlDoc);
        String kmlVersion = kmlDoc.getDocumentElement().getAttribute("version");
        if (kmlVersion.isEmpty()) {
            kmlVersion = "2.2";
        }
        suite.setAttribute(SuiteAttribute.KML_VERSION.getName(), (Object)kmlVersion);
        if (TestSuiteLogger.isLoggable(Level.FINE)) {
            StringBuilder logMsg = new StringBuilder("Parsed KML resource retrieved from ");
            logMsg.append(iutRef).append("\n");
            logMsg.append(XMLUtils.writeNodeToString(kmlDoc));
            TestSuiteLogger.log(Level.FINE, logMsg.toString());
        }
    }

    void registerHttpClient(ISuite suite) {
        Client client = HttpClientUtils.buildClient();
        if (null != client) {
            suite.setAttribute(SuiteAttribute.CLIENT.getName(), (Object)client);
        }
    }
}

