/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c1;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml2.CommonFixture;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.JTSGeometryBuilder;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.CoordinatesValidator;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PolygonTests
extends CommonFixture {
    private CoordinatesValidator coordsValidator = new CoordinatesValidator();

    @BeforeClass
    public void findPolygonElements() {
        this.findTargetElements("Polygon");
    }

    @Test(description="ATC-103, ATC-117")
    public void validPolygonBoundary() {
        JTSGeometryBuilder geomBuilder = new JTSGeometryBuilder();
        Polygon crsPolygon = geomBuilder.buildPolygon(new Envelope(-180.0, 180.0, -90.0, 90.0));
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element polygon = (Element)this.targetElements.item(i);
            NodeList outerRing = null;
            try {
                outerRing = XMLUtils.evaluateXPath(polygon, "kml:outerBoundaryIs/kml:LinearRing", null);
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
            Assert.assertTrue((outerRing.getLength() == 1 ? 1 : 0) != 0, (String)ErrorMessage.format("PolygonBoundary", "Missing outer boundary", XMLUtils.buildXPointer(polygon)));
            Assert.assertTrue((boolean)this.coordsValidator.isValid(outerRing.item(0)), (String)this.coordsValidator.getErrorMessages());
            Polygon jtsPolygon = null;
            try {
                jtsPolygon = geomBuilder.buildPolygon(polygon);
            }
            catch (IllegalArgumentException ex) {
                throw new AssertionError((Object)ErrorMessage.format("PolygonBoundary", ex.getMessage(), XMLUtils.buildXPointer(polygon)));
            }
            Assert.assertTrue((boolean)crsPolygon.covers((Geometry)jtsPolygon), (String)ErrorMessage.format("OutsideCRS", jtsPolygon.toText()));
        }
    }

    @Test(description="ATC-112, ATC-113")
    public void validAltitudeMode() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element polygon = (Element)this.targetElements.item(i);
            ETSAssert.assertValidAltitudeMode(polygon);
        }
    }
}

