/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c1;

import java.net.URI;
import java.net.URL;
import javax.ws.rs.core.MediaType;
import javax.xml.transform.dom.DOMSource;
import org.opengis.cite.kml2.CommonFeatureTests;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.UpdateValidator;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TourTests
extends CommonFeatureTests {
    private UpdateValidator updateValidator = new UpdateValidator();

    @BeforeClass
    public void findTourElements() {
        this.findTargetElements("Tour");
    }

    @Test(description="ATC-141, ATC-142, ATC-143")
    public void checkTourConstraints() {
        URL schRef = this.getClass().getResource("/org/opengis/cite/kml2/sch/kml-tour.sch");
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element tour = (Element)this.targetElements.item(i);
            ETSAssert.assertSchematronValid(schRef, new DOMSource(tour), "MainPhase");
        }
    }

    @Test(description="ATC-144")
    public void soundCue() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element tour = (Element)this.targetElements.item(i);
            NodeList soundCues = tour.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "SoundCue");
            for (int j = 0; j < soundCues.getLength(); ++j) {
                Element soundCue = (Element)soundCues.item(j);
                Node href = soundCue.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "href").item(0);
                Assert.assertNotNull((Object)href, (String)ErrorMessage.format("MissingInfosetItem", "kml:href", XMLUtils.buildXPointer(soundCue)));
                URI uri = URI.create(href.getTextContent().trim());
                if (!uri.isAbsolute()) {
                    uri = uri.resolve(tour.getOwnerDocument().getBaseURI());
                }
                ETSAssert.assertReferentExists(uri, MediaType.valueOf((String)"audio/*"));
            }
        }
    }

    @Test(description="ATC-145")
    public void animatedUpdateTarget() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element tour = (Element)this.targetElements.item(i);
            NodeList updates = tour.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Update");
            for (int j = 0; j < updates.getLength(); ++j) {
                Assert.assertTrue((boolean)this.updateValidator.isValid(updates.item(j)), (String)this.updateValidator.getErrorMessages());
            }
        }
    }
}

