/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c2;

import javax.ws.rs.core.MediaType;
import org.opengis.cite.kml2.CommonFixture;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.LinkValidator;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CL2OverlayTests
extends CommonFixture {
    @BeforeClass
    public void findOverlayElements() {
        this.findTargetElements("GroundOverlay", "ScreenOverlay", "PhotoOverlay");
    }

    @Test(description="ATC-211")
    public void photoOverlayForTiledImage() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element overlay = (Element)this.targetElements.item(i);
            if (!overlay.getLocalName().equals("PhotoOverlay")) continue;
            try {
                ETSAssert.assertXPath("not(contains(kml:Icon/kml:href, '$[')) or kml:ImagePyramid", overlay, null);
                ETSAssert.assertXPath("not(kml:ImagePyramid) or contains(kml:Icon/kml:href, '$[')", overlay, null);
                continue;
            }
            catch (AssertionError e) {
                throw new AssertionError((Object)ErrorMessage.format("ConstraintViolation", "Tiling parameters and ImagePyramid are mutually inclusive", XMLUtils.buildXPointer(overlay)));
            }
        }
    }

    @Test(description="ATC-212")
    public void groundOverlayExtent() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element overlay = (Element)this.targetElements.item(i);
            if (!overlay.getLocalName().equals("GroundOverlay")) continue;
            try {
                ETSAssert.assertXPath("kml:LatLonBox or kml:LatLonQuad", overlay, null);
                continue;
            }
            catch (AssertionError e) {
                throw new AssertionError((Object)ErrorMessage.format("ConstraintViolation", "Expected kml:LatLonBox or kml:LatLonQuad", XMLUtils.buildXPointer(overlay)));
            }
        }
    }

    @Test(description="ATC-216")
    public void screenOverlayPosition() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element overlay = (Element)this.targetElements.item(i);
            if (!overlay.getLocalName().equals("ScreenOverlay")) continue;
            try {
                ETSAssert.assertXPath("kml:screenXY", overlay, null);
                continue;
            }
            catch (AssertionError e) {
                throw new AssertionError((Object)ErrorMessage.format("ConstraintViolation", "Expected kml:screenXY in ScreenOverlay", XMLUtils.buildXPointer(overlay)));
            }
        }
    }

    @Test(description="ATC-215")
    public void overlayImage() {
        LinkValidator linkValidator = new LinkValidator(2, MediaType.valueOf((String)"image/*"));
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element overlay = (Element)this.targetElements.item(i);
            Node icon = overlay.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Icon").item(0);
            Assert.assertNotNull((Object)icon, (String)ErrorMessage.format("MissingInfosetItem", "kml:Icon", XMLUtils.buildXPointer(overlay)));
            Assert.assertTrue((boolean)linkValidator.isValid(icon), (String)linkValidator.getErrorMessages());
        }
    }
}

