/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c3;

import javax.xml.xpath.XPathConstants;
import org.opengis.cite.kml2.CommonFixture;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.XMLUtils;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;

public class CL3ModelTests
extends CommonFixture {
    @BeforeClass
    public void findModelElements() {
        this.findTargetElements("Model");
    }

    @Test(description="ATC-305")
    public void allScalingFactors() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element model = (Element)this.targetElements.item(i);
            Boolean allFactors = (Boolean)XMLUtils.evaluateXPath(model, "kml:Scale[kml:x and kml:y and kml:z]", null, XPathConstants.BOOLEAN);
            if (!allFactors.booleanValue()) {
                throw new AssertionError((Object)ErrorMessage.format("ConstraintViolation", "Expected kml:Scale[kml:x and kml:y and kml:z]", XMLUtils.buildXPointer(model)));
            }
        }
    }

    @Test(description="ATC-307")
    public void allOrientationAngles() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element model = (Element)this.targetElements.item(i);
            Boolean allAngles = (Boolean)XMLUtils.evaluateXPath(model, "kml:Orientation[kml:heading and kml:tilt and kml:roll]", null, XPathConstants.BOOLEAN);
            if (!allAngles.booleanValue()) {
                throw new AssertionError((Object)ErrorMessage.format("ConstraintViolation", "Expected kml:Orientation[kml:heading and kml:tilt and kml:roll]", XMLUtils.buildXPointer(model)));
            }
        }
    }
}

