/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.c3;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.Polygon;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml2.CommonFixture;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.JTSGeometryBuilder;
import org.opengis.cite.kml2.util.XMLUtils;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PlacemarkGeometryTests
extends CommonFixture {
    JTSGeometryBuilder geomBuilder = new JTSGeometryBuilder();

    @BeforeClass
    public void findPlacemarks() {
        this.findTargetElements("Placemark");
    }

    @Test(description="ATC-301")
    public void polygonBoundaryOrientation() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element place = (Element)this.targetElements.item(i);
            Node kmlPolygon = place.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Polygon").item(0);
            if (null == kmlPolygon) continue;
            try {
                Node outerRing = XMLUtils.evaluateXPath(kmlPolygon, "kml:outerBoundaryIs/kml:LinearRing", null).item(0);
                Assert.assertNotNull((Object)outerRing, (String)"Missing ...");
            }
            catch (XPathExpressionException xPathExpressionException) {
                // empty catch block
            }
            Element polygonElem = (Element)kmlPolygon;
            Polygon polygon = this.geomBuilder.buildPolygon(polygonElem);
            Coordinate[] exteriorCoords = polygon.getExteriorRing().getCoordinates();
            Assert.assertTrue((boolean)CGAlgorithms.isCCW((Coordinate[])exteriorCoords), (String)ErrorMessage.format("ExternalBoundaryOrientation", XMLUtils.buildXPointer(polygonElem)));
        }
    }

    @Test(description="ATC-302")
    public void simpleRing() {
        for (int i = 0; i < this.targetElements.getLength(); ++i) {
            Element place = (Element)this.targetElements.item(i);
            Node kmlRing = place.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "LinearRing").item(0);
            if (null == kmlRing) continue;
            Element ringElem = (Element)kmlRing;
            LinearRing ring = this.geomBuilder.buildLinearRing(ringElem);
            Assert.assertTrue((boolean)ring.isSimple(), (String)ErrorMessage.format("SimpleRing", XMLUtils.buildXPointer(ringElem)));
        }
    }
}

