/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.transform.Source;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.ItemTypeFactory;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmItem;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import net.sf.saxon.s9api.XdmValue;
import org.apache.commons.io.IOUtils;
import org.opengis.cite.kml2.AltitudeMode;
import org.opengis.cite.kml2.util.TestSuiteLogger;
import org.opengis.cite.kml2.util.URIUtils;
import org.opengis.cite.kml2.util.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class KMLUtils {
    private static final Logger LOGR = Logger.getLogger(KMLUtils.class.getPackage().getName());

    public static Document parseKMLDocument(File file) throws IOException, SAXException {
        Document kmlDoc = null;
        try (FileInputStream fileStream = new FileInputStream(file);){
            if (XMLUtils.isXML(fileStream)) {
                kmlDoc = (Document)URIUtils.parseURI(file.toURI());
            } else {
                LOGR.log(Level.INFO, "Reading KMZ resource from " + file.toURI());
                kmlDoc = KMLUtils.parseKMLDocumentInArchive(file);
            }
        }
        return kmlDoc;
    }

    public static Document parseKMLDocumentInArchive(File file) throws IOException, SAXException {
        if (!file.exists()) {
            throw new IllegalArgumentException("File does not exist: " + file.getAbsolutePath());
        }
        Document mainKMLDoc = null;
        try (ZipFile zipFile = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File destFile = new File(file.getParent(), entry.getName());
                if (entry.isDirectory()) {
                    destFile.mkdirs();
                    continue;
                }
                InputStream input = zipFile.getInputStream(entry);
                FileOutputStream output = new FileOutputStream(destFile);
                int nBytes = IOUtils.copy((InputStream)input, (OutputStream)output);
                IOUtils.closeQuietly((InputStream)input);
                IOUtils.closeQuietly((OutputStream)output);
                if (null == mainKMLDoc && destFile.getName().endsWith(".kml")) {
                    mainKMLDoc = (Document)URIUtils.parseURI(destFile.toURI());
                }
                if (!TestSuiteLogger.isLoggable(Level.FINER)) continue;
                TestSuiteLogger.log(Level.FINER, String.format("Extracted %d bytes to %s", nBytes, destFile.toURI()));
            }
        }
        return mainKMLDoc;
    }

    public static Set<String> findElementIdentifiers(Source kmlSource, String xpath) {
        XdmValue results = null;
        HashSet<String> idSet = new HashSet<String>();
        try {
            results = XMLUtils.evaluateXPath2(kmlSource, xpath, null);
        }
        catch (SaxonApiException e) {
            Logger.getLogger(KMLUtils.class.getName()).log(Level.WARNING, "Failed to evaluate XPath expression: " + xpath, e);
            return idSet;
        }
        for (XdmItem item : results) {
            QName idName;
            XdmNode node = (XdmNode)item;
            String id = node.getAttributeValue(idName = new QName("id"));
            if (null == id || id.isEmpty()) continue;
            idSet.add(id);
        }
        return idSet;
    }

    public static AltitudeMode getAltitudeMode(Element element) {
        AltitudeMode altMode = AltitudeMode.CLAMP_TO_GROUND;
        Node altitudeMode = element.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "altitudeMode").item(0);
        Node seafloorAltitudeMode = element.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "seaFloorAltitudeMode").item(0);
        if (null != seafloorAltitudeMode) {
            altMode = AltitudeMode.fromString(seafloorAltitudeMode.getTextContent().trim());
        } else if (null != altitudeMode) {
            altMode = AltitudeMode.fromString(altitudeMode.getTextContent().trim());
        }
        return altMode;
    }

    public static Map<String, ItemType> getDeclaredFields(XdmNode schema) {
        if (null == schema || !schema.getNodeName().getLocalName().equals("Schema")) {
            throw new IllegalArgumentException("Not a kml:Schema element.");
        }
        HashMap<String, ItemType> schemaFields = new HashMap<String, ItemType>();
        QName name = new QName("name");
        QName type = new QName("type");
        ItemTypeFactory typeFactory = new ItemTypeFactory(new Processor(false));
        XdmSequenceIterator childItr = schema.axisIterator(Axis.CHILD);
        while (childItr.hasNext()) {
            ItemType atomicType;
            XdmNode child = (XdmNode)childItr.next();
            if (!child.getNodeKind().equals((Object)XdmNodeKind.ELEMENT)) continue;
            QName typeName = new QName("http://www.w3.org/2001/XMLSchema", child.getAttributeValue(type));
            try {
                atomicType = typeFactory.getAtomicType(typeName);
            }
            catch (SaxonApiException e) {
                atomicType = ItemType.ANY_ATOMIC_VALUE;
            }
            schemaFields.put(child.getAttributeValue(name), atomicType);
        }
        return schemaFields;
    }
}

