/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.validation;

import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import javax.xml.transform.dom.DOMSource;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmAtomicValue;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.KMLUtils;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.SchemaChecker;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ExtendedDataValidator {
    ValidationErrorHandler errHandler = new ValidationErrorHandler();
    SchemaChecker schemaChecker = new SchemaChecker();
    Document ownerDocument;

    void setOwnerDocument(Document doc) {
        this.ownerDocument = doc;
    }

    public String getErrorMessages() {
        return this.errHandler.toString();
    }

    public boolean isValid(Node node) {
        if (!node.getLocalName().equals("ExtendedData")) {
            throw new IllegalArgumentException("Not an ExtendedData element: " + node.getLocalName());
        }
        this.errHandler.reset();
        this.ownerDocument = node.getOwnerDocument();
        Element extData = (Element)node;
        this.checkData(extData);
        this.checkSchemaData(extData);
        return !this.errHandler.errorsDetected();
    }

    void checkData(Element extData) {
        NodeList dataList = extData.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Data");
        HashSet<String> nameSet = new HashSet<String>(dataList.getLength());
        for (int i = 0; i < dataList.getLength(); ++i) {
            Element data = (Element)dataList.item(i);
            String name = data.getAttribute("name");
            if (!nameSet.add(name)) {
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("DuplicateData", name), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(extData)));
            }
            this.schemaChecker.checkUnitOfMeasure(data);
        }
        this.errHandler.addErrors(this.schemaChecker.getErrors());
    }

    void checkSchemaData(Element extData) {
        NodeList schemaDataList = extData.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "SchemaData");
        for (int i = 0; i < schemaDataList.getLength(); ++i) {
            Element schemaData = (Element)schemaDataList.item(i);
            String schemaUrl = schemaData.getAttribute("schemaUrl");
            if (schemaUrl.isEmpty()) {
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("MissingInfosetItem", "@schemaUrl"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(schemaData)));
                continue;
            }
            URI schemaURI = URI.create(schemaUrl);
            XdmNode schema = null;
            try {
                schema = this.fetchSchema(schemaURI);
            }
            catch (RuntimeException | SaxonApiException e) {
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("NotFound", schemaURI), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(schemaData)));
                continue;
            }
            Map<String, ItemType> schemaFields = KMLUtils.getDeclaredFields(schema);
            this.validateSchemaData(schemaData, schemaFields);
        }
    }

    void validateSchemaData(Element schemaData, Map<String, ItemType> schemaFields) {
        NodeList dataNodes = null;
        try {
            dataNodes = XMLUtils.evaluateXPath(schemaData, "kml:SimpleData | kml:SimpleArrayData", null);
        }
        catch (XPathExpressionException xPathExpressionException) {
            // empty catch block
        }
        for (int i = 0; i < dataNodes.getLength(); ++i) {
            String[] dataValues;
            Element data = (Element)dataNodes.item(i);
            String name = data.getAttribute("name");
            if (!schemaFields.containsKey(name)) {
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "Name not found in custom schema: " + name), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(data)));
            }
            for (String value : dataValues = this.getDataValues(data)) {
                try {
                    XdmAtomicValue xdmAtomicValue = new XdmAtomicValue(value, schemaFields.get(name));
                }
                catch (SaxonApiException e) {
                    this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", e.getMessage()), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(data)));
                }
            }
        }
    }

    String[] getDataValues(Element data) {
        String[] values = null;
        if (data.getLocalName().equals("SimpleData")) {
            values = new String[]{data.getTextContent().trim()};
        } else {
            NodeList valueList = data.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "value");
            values = new String[valueList.getLength()];
            for (int i = 0; i < valueList.getLength(); ++i) {
                values[i] = valueList.item(i).getTextContent().trim();
            }
        }
        return values;
    }

    XdmNode fetchSchema(URI schemaURI) throws SaxonApiException, RuntimeException {
        String xpath;
        if (null == schemaURI.getScheme()) {
            xpath = String.format("//kml:Schema[@id='%s']", schemaURI.getFragment());
        } else {
            int numSign = schemaURI.toString().indexOf(35);
            xpath = String.format("doc('%s')//kml:Schema[@id='%s']", schemaURI.toString().substring(0, numSign), schemaURI.getFragment());
        }
        DOMSource src = new DOMSource(this.ownerDocument, this.ownerDocument.getBaseURI());
        XdmValue result = XMLUtils.evaluateXPath2(src, xpath, null);
        return (XdmNode)result.itemAt(0);
    }
}

