/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.validation;

import com.vividsolutions.jts.algorithm.CGAlgorithms;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.JTSGeometryBuilder;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.CoordinatesValidator;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationError;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.Assert;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class GeoExtentValidator {
    private static final String BOX_NORTH = "north";
    private static final String BOX_SOUTH = "south";
    private static final String BOX_EAST = "east";
    private static final String BOX_WEST = "west";
    private static final String BOX_MIN_ALT = "minAltitude";
    private static final String BOX_MAX_ALT = "maxAltitude";
    private static final Map<String, Double> DEFAULT_BOX = GeoExtentValidator.initDefaultBox();
    private ValidationErrorHandler errHandler = new ValidationErrorHandler();
    private CoordinatesValidator coordsValidator = new CoordinatesValidator();

    private static Map<String, Double> initDefaultBox() {
        HashMap<String, Double> defaultBox = new HashMap<String, Double>();
        defaultBox.put(BOX_NORTH, 90.0);
        defaultBox.put(BOX_SOUTH, -90.0);
        defaultBox.put(BOX_EAST, 180.0);
        defaultBox.put(BOX_WEST, -180.0);
        defaultBox.put(BOX_MIN_ALT, 0.0);
        defaultBox.put(BOX_MAX_ALT, 0.0);
        return Collections.unmodifiableMap(defaultBox);
    }

    public String getErrorMessages() {
        return this.errHandler.toString();
    }

    public Iterator<ValidationError> getErrors() {
        return this.errHandler.iterator();
    }

    public void reset() {
        this.errHandler.reset();
    }

    public boolean validGeoExtent(Node node) {
        this.errHandler.reset();
        boolean isValid = false;
        isValid = node.getLocalName().endsWith("Box") ? this.validateBox(node) : this.validateQuadrilateral(node);
        return isValid;
    }

    public boolean validateQuadrilateral(Node latlonQuad) {
        JTSGeometryBuilder jtsBuilder = new JTSGeometryBuilder();
        Polygon crsPolygon = jtsBuilder.buildPolygon(new Envelope(-180.0, 180.0, -90.0, 90.0));
        Element quad = (Element)latlonQuad;
        Assert.assertTrue((boolean)this.coordsValidator.isValid(quad), (String)this.coordsValidator.getErrorMessages());
        Polygon jtsPolygon = null;
        try {
            Node coords = quad.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "coordinates").item(0);
            jtsPolygon = jtsBuilder.buildPolygonFromCoordinates(coords);
        }
        catch (IllegalArgumentException ex) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("PolygonBoundary", ex.getMessage()), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(quad)));
        }
        if (!crsPolygon.covers((Geometry)jtsPolygon)) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("OutsideCRS", jtsPolygon.toText()), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(quad)));
        }
        if (!CGAlgorithms.isCCW((Coordinate[])jtsPolygon.getCoordinates())) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("RingNotCCW", jtsPolygon.toText()), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(quad)));
        }
        if (!jtsPolygon.convexHull().equalsTopo((Geometry)jtsPolygon)) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("QuadNotConvex", jtsPolygon.toText()), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(quad)));
        }
        return !this.errHandler.errorsDetected();
    }

    boolean validateBox(Node boxNode) {
        if (null == boxNode || !boxNode.getLocalName().startsWith("LatLon")) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("MissingInfosetItem", "kml:LatLon*"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(boxNode)));
            return false;
        }
        Map<String, Double> boxProps = this.getNumericProperties(boxNode, DEFAULT_BOX);
        if (boxProps.get(BOX_NORTH) <= boxProps.get(BOX_SOUTH)) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[kml:LatLonAltBox] kml:north > kml:south"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(boxNode)));
        }
        if (boxProps.get(BOX_EAST) <= boxProps.get(BOX_WEST)) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[kml:LatLonAltBox] kml:east > kml:west"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(boxNode)));
        }
        if (boxProps.get(BOX_MIN_ALT) > boxProps.get(BOX_MAX_ALT)) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[kml:LatLonAltBox] kml:minAltitude <= kml:maxAltitude"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(boxNode)));
        }
        if (boxProps.get(BOX_EAST) - boxProps.get(BOX_WEST) > 360.0) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[kml:LatLonAltBox] kml:east - kml:west <= 360 (non-self-overlap)"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(boxNode)));
        }
        if ((Math.abs(boxProps.get(BOX_WEST)) > 180.0 || Math.abs(boxProps.get(BOX_EAST)) > 180.0) && (boxProps.get(BOX_EAST) <= 0.0 || boxProps.get(BOX_WEST) >= 180.0)) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[kml:LatLonAltBox] kml:east > 0 and kml:west < 180 (uniqueness)"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(boxNode)));
        }
        if (((Boolean)XMLUtils.evaluateXPath(boxNode, "kml:minAltitude and kml:maxAltitude", null, XPathConstants.BOOLEAN)).booleanValue()) {
            String altModeValue;
            Element latLonAltBox = (Element)Element.class.cast(boxNode);
            Node altMode = latLonAltBox.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "altitudeMode").item(0);
            String string = altModeValue = null != altMode ? altMode.getTextContent().trim() : "clampToGround";
            if (altModeValue.equals("clampToGround")) {
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[ATC-108] kml:altitudeMode != 'clampToGround' in kml:LatLonAltBox with kml:minAltitude and kml:maxAltitude"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(boxNode)));
            }
        }
        return !this.errHandler.errorsDetected();
    }

    Map<String, Double> getNumericProperties(Node node, Map<String, Double> defaults) {
        if (null == defaults) {
            defaults = new HashMap<String, Double>();
        }
        HashMap<String, Double> properties = new HashMap<String, Double>(defaults);
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            try {
                Double value = Double.valueOf(child.getTextContent());
                properties.put(child.getLocalName(), value);
                continue;
            }
            catch (NumberFormatException ex) {
                // empty catch block
            }
        }
        return properties;
    }
}

