/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.validation;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.net.URI;
import java.util.Arrays;
import java.util.Iterator;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.HttpClientUtils;
import org.opengis.cite.kml2.util.URIUtils;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationError;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LinkValidator {
    private int conformanceLevel = 1;
    private ValidationErrorHandler errHandler = new ValidationErrorHandler();
    private MediaType[] mediaTypes;
    private Client httpClient;

    public LinkValidator(MediaType ... mediaTypes) {
        this.mediaTypes = mediaTypes;
        this.httpClient = HttpClientUtils.buildClient();
    }

    public LinkValidator(int level, MediaType ... mediaTypes) {
        this(mediaTypes);
        if (level > 0 && level < 4) {
            this.conformanceLevel = level;
        }
    }

    public String getErrorMessages() {
        return this.errHandler.toString();
    }

    public Iterator<ValidationError> getErrors() {
        return this.errHandler.iterator();
    }

    public void reset() {
        this.errHandler.reset();
    }

    public boolean isValid(Node node) {
        this.errHandler.reset();
        Element link = (Element)node;
        this.checkLinkReferent(link);
        this.checkLinkProperties(link);
        if (this.conformanceLevel > 1) {
            this.checkLinkConstraintsAtLevel2(link);
        }
        return !this.errHandler.errorsDetected();
    }

    void checkLinkReferent(Element link) {
        NodeList hrefList = link.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "href");
        if (hrefList.getLength() == 0) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("MissingInfosetItem", "kml:href"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(link)));
            return;
        }
        String href = hrefList.item(0).getTextContent();
        if (href.contains("$[")) {
            href = href.replaceAll("\\$\\[\\w+]", "0");
        }
        URI uri = URI.create(href);
        try {
            if (!uri.isAbsolute()) {
                uri = URIUtils.resolveRelativeURI(link.getOwnerDocument().getBaseURI(), uri.toString());
            }
            if (!uri.getScheme().equalsIgnoreCase("http")) {
                File file = new File(uri);
                if (!file.exists()) {
                    throw new FileNotFoundException("File not found");
                }
            } else {
                String contentType;
                ClientRequest req = HttpClientUtils.buildHeadRequest(uri, null, this.mediaTypes);
                ClientResponse rsp = this.httpClient.handle(req);
                if (rsp.getStatusInfo().getFamily() == Response.Status.Family.REDIRECTION) {
                    URI newURI = rsp.getLocation();
                    req.setURI(newURI);
                    rsp = this.httpClient.handle(req);
                }
                if (rsp.getStatus() == Response.Status.FORBIDDEN.getStatusCode()) {
                    req = HttpClientUtils.buildGetRequest(uri, null, this.mediaTypes);
                    rsp = this.httpClient.handle(req);
                }
                if (rsp.getStatus() != 200) {
                    this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("UnexpectedStatus", uri, rsp.getStatus()), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(link)));
                }
                if (!HttpClientUtils.contentIsAcceptable(contentType = rsp.getType().toString(), this.mediaTypes)) {
                    this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("UnacceptableMediaType", contentType, Arrays.toString(this.mediaTypes)), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(link)));
                }
            }
        }
        catch (Exception e) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("URINotAccessible", uri, e.getMessage()), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(link)));
        }
    }

    void checkLinkProperties(Element link) {
        Node viewBound;
        Node viewRefresh;
        Node refresh = link.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "refreshInterval").item(0);
        if (null != refresh && Double.parseDouble(refresh.getTextContent()) <= 0.0) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "kml:refreshInterval > 0"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(link)));
        }
        if (null != (viewRefresh = link.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "viewRefreshTime").item(0)) && Double.parseDouble(viewRefresh.getTextContent()) <= 0.0) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "kml:viewRefreshTime > 0"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(link)));
        }
        if (null != (viewBound = link.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "viewBoundScale").item(0)) && Double.parseDouble(viewBound.getTextContent()) <= 0.0) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "kml:viewBoundScale > 0"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(link)));
        }
    }

    void checkLinkConstraintsAtLevel2(Element link) {
        Node httpQuery;
        Node viewFormat = link.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "viewFormat").item(0);
        if (null != viewFormat && viewFormat.getTextContent().isEmpty()) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "kml:viewFormat is not empty"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(link)));
        }
        if (null != (httpQuery = link.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "httpQuery").item(0)) && httpQuery.getTextContent().isEmpty()) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "kml:httpQuery is not empty"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(link)));
        }
        try {
            ETSAssert.assertXPath("not(kml:refreshInterval) or kml:refreshMode = 'onInterval'", link, null);
            ETSAssert.assertXPath("not(kml:viewRefreshTime) or kml:refreshMode = 'onStop'", link, null);
        }
        catch (AssertionError e) {
            this.errHandler.addError(ErrorSeverity.ERROR, ((Throwable)((Object)e)).getMessage(), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(link)));
        }
    }
}

