/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.validation;

import java.util.Iterator;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.kml2.validation.GeoExtentValidator;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationError;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegionValidator {
    private ValidationErrorHandler errHandler = new ValidationErrorHandler();
    private GeoExtentValidator geoExtentValidator = new GeoExtentValidator();
    private int conformanceLevel = 1;

    public RegionValidator() {
    }

    public RegionValidator(int level) {
        this();
        if (level > 0 && level < 4) {
            this.conformanceLevel = level;
        }
    }

    public String getErrorMessages() {
        return this.errHandler.toString();
    }

    public boolean isValid(Node node) {
        this.errHandler.reset();
        Element region = (Element)node;
        this.checkRegionExtent(region);
        this.checkRegionVisibility(region);
        if (this.conformanceLevel > 2) {
            this.checkLodFadeRange(region);
        }
        return !this.errHandler.errorsDetected();
    }

    void checkRegionExtent(Element region) {
        Node boxNode = region.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "LatLonAltBox").item(0);
        if (null == boxNode) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[ATC-140] Expected LatLonAtlBox"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(region)));
            return;
        }
        if (!this.geoExtentValidator.validGeoExtent(boxNode)) {
            Iterator<ValidationError> errors = this.geoExtentValidator.getErrors();
            while (errors.hasNext()) {
                ValidationError err = errors.next();
                this.errHandler.addError(err.getSeverity(), err.getMessage(), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(boxNode)));
            }
        }
    }

    void checkRegionVisibility(Element region) {
        double maxLodPixels;
        Node lodNode = region.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Lod").item(0);
        if (null == lodNode) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[ATC-140] Expected Lod"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(region)));
            return;
        }
        Node minLodPixelsNode = region.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "minLodPixels").item(0);
        if (null == minLodPixelsNode) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[ATC-138] Expected minLodPixels in Lod"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(region)));
            return;
        }
        double minLodPixels = Double.parseDouble(minLodPixelsNode.getTextContent());
        Node maxLodPixelsNode = region.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "maxLodPixels").item(0);
        double d = maxLodPixels = null == maxLodPixelsNode ? Double.POSITIVE_INFINITY : Double.parseDouble(maxLodPixelsNode.getTextContent());
        if (maxLodPixels == -1.0) {
            maxLodPixels = Double.POSITIVE_INFINITY;
        }
        if (minLodPixels >= maxLodPixels) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[ATC-138] Expected minLodPixels < maxLodPixels in Lod"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(region)));
        }
    }

    void checkLodFadeRange(Element region) {
        double maxFadeExtent;
        double minLodPixels = this.getLodParameterValue(region, "minLodPixels");
        double maxLodPixels = this.getLodParameterValue(region, "maxLodPixels");
        double minFadeExtent = this.getLodParameterValue(region, "minFadeExtent");
        if (minFadeExtent + (maxFadeExtent = this.getLodParameterValue(region, "maxFadeExtent")) > maxLodPixels - minLodPixels) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[ATC-306] Region has invalid Lod fade range"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(region)));
        }
    }

    double getLodParameterValue(Element region, String paramName) {
        double lodParamValue = paramName.equals("maxLodPixels") ? Double.POSITIVE_INFINITY : 0.0;
        Node lodParam = region.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", paramName).item(0);
        if (null != lodParam) {
            lodParamValue = Double.parseDouble(lodParam.getTextContent());
        }
        return lodParamValue;
    }
}

