/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.validation;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.core.MediaType;
import javax.xml.transform.stream.StreamSource;
import net.sf.saxon.s9api.ItemType;
import net.sf.saxon.s9api.ItemTypeFactory;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.kml2.ETSAssert;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationError;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SchemaChecker {
    private static final String UCUM_NS = "http://unitsofmeasure.org/ucum-essence";
    ValidationErrorHandler errHandler = new ValidationErrorHandler();
    URL uomCodeListRef = SchemaChecker.class.getResource("ucum.xml");
    List<String> commonPrefixes = Arrays.asList("E", "P", "T", "G", "M", "k", "h", "da", "d", "c", "m", "u", "n", "p", "f", "a");

    List<String> getUomPrefixes() {
        return this.commonPrefixes;
    }

    public String getErrorMessages() {
        return this.errHandler.toString();
    }

    public List<ValidationError> getErrors() {
        return this.errHandler.getErrors();
    }

    public boolean isValid(Node node) {
        if (!node.getLocalName().equals("Schema")) {
            throw new IllegalArgumentException("Not a Schema element: " + node.getLocalName());
        }
        this.errHandler.reset();
        Element schema = (Element)node;
        if (schema.getAttribute("id").isEmpty()) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("MissingInfosetItem", "@id"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(schema)));
        }
        this.checkSimpleFields(schema);
        this.checkSimpleArrayFields(schema);
        return !this.errHandler.errorsDetected();
    }

    void checkSimpleFields(Element schema) {
        NodeList simpleFields = schema.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "SimpleField");
        for (int i = 0; i < simpleFields.getLength(); ++i) {
            Element simpleField = (Element)simpleFields.item(i);
            if (simpleField.getAttribute("name").isEmpty()) {
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("MissingInfosetItem", "@name"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(simpleField)));
            }
            this.checkDataType(simpleField);
            this.checkUnitOfMeasure(simpleField);
        }
    }

    void checkSimpleArrayFields(Element schema) {
        NodeList arrayFields = schema.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "SimpleArrayField");
        for (int i = 0; i < arrayFields.getLength(); ++i) {
            Element arrayField = (Element)arrayFields.item(i);
            this.checkUnitOfMeasure(arrayField);
        }
    }

    void checkDataType(Element simpleField) {
        String type = simpleField.getAttribute("type");
        if (type.isEmpty()) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("MissingInfosetItem", "@type"), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(simpleField)));
            return;
        }
        QName typeName = new QName("http://www.w3.org/2001/XMLSchema", type);
        ItemTypeFactory typeFactory = new ItemTypeFactory(new Processor(false));
        try {
            ItemType itemType = typeFactory.getAtomicType(typeName);
        }
        catch (SaxonApiException e) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("InvalidDatatype", e.getMessage()), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(simpleField)));
        }
    }

    public void checkUnitOfMeasure(Element schemaField) {
        String uom = schemaField.getAttribute("uom");
        if (uom.isEmpty()) {
            return;
        }
        try {
            URI uomRef = URI.create(URLEncoder.encode(uom, "UTF-8"));
            if (uomRef.isAbsolute()) {
                ETSAssert.assertReferentExists(uomRef, MediaType.WILDCARD_TYPE);
                return;
            }
        }
        catch (UnsupportedEncodingException | AssertionError e) {
            this.errHandler.addError(ErrorSeverity.ERROR, ((Throwable)e).getMessage(), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(schemaField)));
            return;
        }
        String uomCode = uom;
        for (String prefix : this.commonPrefixes) {
            if (!uom.startsWith(prefix)) continue;
            uomCode = uom.replace(prefix, "");
            break;
        }
        String xpath = String.format("//(ucum:base-unit | ucum:unit)[@Code = '%s']", uomCode);
        StreamSource uomSource = new StreamSource(this.uomCodeListRef.toString());
        try {
            XdmValue result = XMLUtils.evaluateXPath2(uomSource, xpath, Collections.singletonMap(UCUM_NS, "ucum"));
            if (result.size() == 0) {
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("UnitOfMeasureNotDefined", uom), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(schemaField)));
            }
        }
        catch (SaxonApiException saxonApiException) {
            // empty catch block
        }
    }
}

