/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml2.validation;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import org.opengis.cite.kml2.ErrorMessage;
import org.opengis.cite.kml2.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TrackValidator {
    static final Envelope CRS_EXTENT = new Envelope(-180.0, 180.0, -90.0, 90.0);
    ValidationErrorHandler errHandler = new ValidationErrorHandler();

    public String getErrorMessages() {
        return this.errHandler.toString();
    }

    public void reset() {
        this.errHandler.reset();
    }

    public boolean isValid(Node node) {
        this.errHandler.reset();
        Element track = (Element)node;
        this.checkCoordList(track);
        if (track.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "when").getLength() != track.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "coord").getLength()) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "Expected count(kml:when) = count(kml:coord) in Track", ""), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(track)));
        }
        this.checkAngles(track);
        return !this.errHandler.errorsDetected();
    }

    void checkCoordList(Element track) {
        NodeList coordList = track.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "coord");
        if (coordList.getLength() == 0) {
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "Expected kml:coord in Track", ""), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(track)));
            return;
        }
        for (int i = 0; i < coordList.getLength(); ++i) {
            Node coordNode = coordList.item(i);
            if (coordNode.getTextContent().isEmpty()) continue;
            double[] coord = this.getNumericValues(coordNode);
            if (coord.length != 3) {
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("CoordDim", i, "3", coord.length), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(coordNode)));
                continue;
            }
            Coordinate jtsCoord = new Coordinate(coord[0], coord[1], coord[2]);
            if (CRS_EXTENT.intersects(jtsCoord)) continue;
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("OutsideCRS", jtsCoord.toString()), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(coordNode)));
        }
    }

    void checkAngles(Element track) {
        NodeList anglesList = track.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "angles");
        for (int i = 0; i < anglesList.getLength(); ++i) {
            Node anglesNode = anglesList.item(i);
            if (anglesNode.getTextContent().isEmpty()) continue;
            double[] angles = this.getNumericValues(anglesNode);
            if (null != track.getElementsByTagNameNS("http://www.opengis.net/kml/2.2", "Model").item(0) || angles.length <= 1) continue;
            this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("ConstraintViolation", "[ATC-148] Expected one angle value, since Track has no Model", ""), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(anglesNode)));
        }
    }

    double[] getNumericValues(Node node) {
        String[] values = node.getTextContent().trim().split("\\s+");
        double[] numericValues = new double[values.length];
        for (int j = 0; j < values.length; ++j) {
            try {
                numericValues[j] = Double.parseDouble(values[j]);
                continue;
            }
            catch (NumberFormatException e) {
                this.errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("NaN", values[j]), new ErrorLocator(-1, -1, XMLUtils.buildXPointer(node)));
            }
        }
        return numericValues;
    }
}

