/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.kml22;

import java.util.Collections;
import java.util.Map;
import javax.xml.xpath.XPathExpressionException;
import org.opengis.cite.kml22.ErrorMessage;
import org.opengis.cite.kml22.SuiteAttribute;
import org.opengis.cite.kml22.util.XMLUtils;
import org.opengis.cite.validation.ErrorLocator;
import org.opengis.cite.validation.ErrorSeverity;
import org.opengis.cite.validation.ValidationErrorHandler;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BaseFixture {
    protected static final Map<String, String> NS_MAP = Collections.singletonMap("http://www.opengis.net/kml/2.2", "kml");
    protected Document testSubject;

    @BeforeClass(alwaysRun=true)
    public void obtainTestSubject(ITestContext testContext) {
        Object obj = testContext.getSuite().getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        if (null != obj && Document.class.isAssignableFrom(obj.getClass())) {
            this.testSubject = (Document)Document.class.cast(obj);
        }
    }

    public void setTestSubject(Document testSubject) {
        this.testSubject = testSubject;
    }

    protected void verifyElementNotEmpty(String localName, ValidationErrorHandler errHandler) {
        String xpath = String.format("//kml:%s[not(ancestor::kml:Update)]", localName);
        NodeList nodeList = null;
        try {
            nodeList = XMLUtils.evaluateXPath(this.testSubject, xpath, NS_MAP);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                NodeList kmlChildren = XMLUtils.evaluateXPath(node, "kml:*", NS_MAP);
                if (kmlChildren.getLength() != 0) continue;
                errHandler.addError(ErrorSeverity.ERROR, ErrorMessage.format("level2.Empty", localName), new ErrorLocator(-1, -1, XMLUtils.getXPointer(node)));
            }
        }
        catch (XPathExpressionException xpe) {
            throw new RuntimeException(xpe);
        }
    }
}

