/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142;

import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.validation.Schema;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.TestRunArg;
import org.opengis.cite.iso19142.WFS2;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.URIUtils;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.testng.ISuite;
import org.testng.ISuiteListener;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class SuiteFixtureListener
implements ISuiteListener {
    private static final Logger LOGR = Logger.getLogger(SuiteFixtureListener.class.getName());

    public void onStart(ISuite suite) {
        Schema wfsSchema = ValidationUtils.createWFSSchema();
        if (null != wfsSchema) {
            suite.setAttribute(SuiteAttribute.WFS_SCHEMA.getName(), (Object)wfsSchema);
        }
        this.processWfsParameter(suite);
        this.setAppSchemaParameter(suite);
        LOGR.log(Level.CONFIG, "Initial test run parameters:\n{0}", suite.getXmlSuite().getAllParameters());
    }

    public void onFinish(ISuite suite) {
    }

    void processWfsParameter(ISuite suite) {
        String wfsRef;
        Map params = suite.getXmlSuite().getParameters();
        String iutRef = (String)params.get(TestRunArg.IUT.toString());
        String string = wfsRef = null != iutRef ? iutRef : (String)params.get(TestRunArg.WFS.toString());
        if (null == wfsRef || wfsRef.isEmpty()) {
            throw new IllegalArgumentException("Required parameter not found");
        }
        URI wfsURI = URI.create(wfsRef);
        Document doc = null;
        try {
            doc = URIUtils.resolveURIAsDocument(wfsURI);
            Element docElem = doc.getDocumentElement();
            QName qName = new QName(docElem.getNamespaceURI(), docElem.getLocalName());
            if (!qName.equals(WFS2.QNAME_WFS_CAPABILITIES)) {
                throw new RuntimeException("Not a WFS2 capabilities document: " + qName);
            }
        }
        catch (IOException | SAXException ex) {
            throw new RuntimeException("Failed to parse resource located at " + wfsURI, ex);
        }
        if (null != doc) {
            suite.setAttribute(SuiteAttribute.TEST_SUBJECT.getName(), (Object)doc);
            Map<QName, FeatureTypeInfo> featureInfo = ServiceMetadataUtils.extractFeatureInfo(doc);
            suite.setAttribute(SuiteAttribute.FEATURE_INFO.getName(), featureInfo);
            LOGR.log(Level.FINER, "Parsed resource from {0}\n{1}", new Object[]{wfsURI, XMLUtils.writeNodeToString(doc)});
        }
    }

    void setAppSchemaParameter(ISuite suite) {
        if (null == suite.getAttribute(SuiteAttribute.TEST_SUBJECT.getName())) {
            return;
        }
        Document wfsMetadata = (Document)suite.getAttribute(SuiteAttribute.TEST_SUBJECT.getName());
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(wfsMetadata, "DescribeFeatureType", ProtocolBinding.GET);
        if (endpoint.toString().isEmpty()) {
            throw new RuntimeException("DescribeFeatureType request endpoint (GET method) not found in capabilities.");
        }
        LOGR.log(Level.CONFIG, "DescribeFeatureType request endpoint: {0}", endpoint);
        if (endpoint.isAbsolute()) {
            StringBuilder reqURI = new StringBuilder(endpoint.toString());
            reqURI.append("?service=WFS&version=2.0.0&request=DescribeFeatureType");
            Map params = suite.getXmlSuite().getParameters();
            params.put(org.opengis.cite.iso19136.TestRunArg.XSD.toString(), reqURI.toString());
            LOGR.log(Level.CONFIG, "Set suite parameter {0}: {1}", new Object[]{org.opengis.cite.iso19136.TestRunArg.XSD, reqURI});
        }
    }
}

