/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142;

import java.awt.RenderingHints;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.geotoolkit.factory.Hints;
import org.geotoolkit.referencing.factory.epsg.EpsgInstaller;
import org.opengis.cite.iso19142.util.TestSuiteLogger;
import org.opengis.util.FactoryException;
import org.testng.IExecutionListener;

public class TestRunListener
implements IExecutionListener {
    public void onExecutionStart() {
        DataSource epsgDataSource = null;
        try {
            InitialContext initContext = new InitialContext();
            Context envContext = (Context)initContext.lookup("java:/comp/env");
            epsgDataSource = (DataSource)envContext.lookup("jdbc/EPSG");
        }
        catch (NamingException nx) {
            TestSuiteLogger.log(Level.CONFIG, "DataSource 'jdbc/EPSG' was not found. An embedded database will be created if necessary.");
        }
        if (null != epsgDataSource) {
            this.checkEpsgDataSource(epsgDataSource);
            Hints.putSystemDefault((RenderingHints.Key)Hints.EPSG_DATA_SOURCE, (Object)epsgDataSource);
        }
    }

    public void onExecutionFinish() {
    }

    void checkEpsgDataSource(DataSource dataSource) {
        if (null == dataSource) {
            throw new IllegalArgumentException("DataSource is null.");
        }
        try (Connection dbConn = dataSource.getConnection();){
            boolean epsgSchemaExists = false;
            ResultSet schemas = dbConn.getMetaData().getSchemas();
            while (schemas.next()) {
                if (!schemas.getString(1).equalsIgnoreCase("EPSG")) continue;
                epsgSchemaExists = true;
                break;
            }
            if (!epsgSchemaExists) {
                TestSuiteLogger.log(Level.WARNING, "EPSG schema not found in DataSource--it will be created.");
                EpsgInstaller installer = new EpsgInstaller();
                installer.setDatabase(dbConn);
                EpsgInstaller.Result result = installer.call();
                TestSuiteLogger.log(Level.INFO, result.toString());
            }
        }
        catch (SQLException | FactoryException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

