/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter;

import com.sun.jersey.api.client.ClientResponse;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.transform.dom.DOMSource;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PropertyIsLikeOperatorTests
extends QueryFilterFixture {
    @Test(description="See ISO 19143: 7.7.3.4, 7.10", dataProvider="protocol-featureType")
    public void propertyIsNotLike(ProtocolBinding binding, QName featureType) {
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        Map<QName, String> patternMap = this.generateMatchingStringPattern(featureType);
        if (patternMap.isEmpty()) {
            throw new SkipException("No string property values found for feature type " + featureType);
        }
        Map.Entry<QName, String> propPattern = patternMap.entrySet().iterator().next();
        this.addPropertyIsLikePredicate(this.reqEntity, propPattern.getKey(), propPattern.getValue(), true);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        NodeList features = this.rspEntity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        String xpath = String.format("not(matches(ns1:%s[1], '%s'))", propPattern.getKey().getLocalPart(), propPattern.getValue().replace("*", ".*"));
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(propPattern.getKey().getNamespaceURI(), "ns1");
        for (int i = 0; i < features.getLength(); ++i) {
            ETSAssert.assertXPath2(xpath, new DOMSource(features.item(i)), nsBindings);
        }
    }

    @Test(description="See ISO 19143: 7.7.3.4", dataProvider="protocol-featureType")
    public void propertyIsLike(ProtocolBinding binding, QName featureType) {
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        Map<QName, String> patternMap = this.generateMatchingStringPattern(featureType);
        if (patternMap.isEmpty()) {
            throw new SkipException("No string property values found for feature type " + featureType);
        }
        Map.Entry<QName, String> propPattern = patternMap.entrySet().iterator().next();
        this.addPropertyIsLikePredicate(this.reqEntity, propPattern.getKey(), propPattern.getValue(), false);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        NodeList features = this.rspEntity.getElementsByTagNameNS(featureType.getNamespaceURI(), featureType.getLocalPart());
        String xpath = String.format("matches(ns1:%s[1], '%s')", propPattern.getKey().getLocalPart(), propPattern.getValue().replace("*", ".*"));
        HashMap<String, String> nsBindings = new HashMap<String, String>();
        nsBindings.put(propPattern.getKey().getNamespaceURI(), "ns1");
        for (int i = 0; i < features.getLength(); ++i) {
            ETSAssert.assertXPath2(xpath, new DOMSource(features.item(i)), nsBindings);
        }
    }

    void addPropertyIsLikePredicate(Document request, QName propertyName, String pattern, boolean negate) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        if (null == propertyName) {
            throw new IllegalArgumentException("propertyName is required.");
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
        queryElem.appendChild(filter);
        Element predicate = request.createElementNS("http://www.opengis.net/fes/2.0", "PropertyIsLike");
        predicate.setAttribute("wildCard", "*");
        predicate.setAttribute("singleChar", "?");
        predicate.setAttribute("escapeChar", "\\");
        if (negate) {
            Element not = request.createElementNS("http://www.opengis.net/fes/2.0", "Not");
            filter.appendChild(not);
            not.appendChild(predicate);
        } else {
            filter.appendChild(predicate);
        }
        Element valueRef = request.createElementNS("http://www.opengis.net/fes/2.0", "ValueReference");
        predicate.appendChild(valueRef);
        String prefix = propertyName.getPrefix().length() > 0 ? propertyName.getPrefix() : "tns";
        String nsURI = request.lookupNamespaceURI(prefix);
        if (null == nsURI) {
            valueRef.setAttribute("xmlns:" + prefix, propertyName.getNamespaceURI());
        }
        valueRef.setTextContent(prefix + ":" + propertyName.getLocalPart());
        Element literal = request.createElementNS("http://www.opengis.net/fes/2.0", "Literal");
        literal.setTextContent(pattern);
        predicate.appendChild(literal);
    }

    Map<QName, String> generateMatchingStringPattern(QName featureType) {
        QName propName = null;
        String pattern = null;
        XSTypeDefinition stringType = this.model.getTypeDefinition("string", "http://www.w3.org/2001/XMLSchema");
        List<XSElementDeclaration> strProps = AppSchemaUtils.getFeaturePropertiesByType(this.model, featureType, stringType);
        ListIterator<XSElementDeclaration> listItr = strProps.listIterator(strProps.size());
        while (listItr.hasPrevious()) {
            XSElementDeclaration prop = listItr.previous();
            propName = new QName(prop.getNamespace(), prop.getName());
            List<String> values = this.dataSampler.getSimplePropertyValues(featureType, propName, null);
            if (values.isEmpty()) continue;
            StringBuilder patternBuilder = new StringBuilder(values.get(0));
            patternBuilder.replace(0, 2, "*");
            pattern = patternBuilder.toString();
            break;
        }
        HashMap<QName, String> map = new HashMap<QName, String>();
        if (null != pattern) {
            map.put(propName, pattern);
        }
        return map;
    }
}

