/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter;

import com.sun.jersey.api.client.ClientResponse;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSElementDeclaration;
import org.opengis.cite.iso19136.util.TestSuiteLogger;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.FeatureTypeInfo;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.AppSchemaUtils;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PropertyIsNilOperatorTests
extends QueryFilterFixture {
    Map<QName, List<XSElementDeclaration>> nillableProperties;

    @BeforeClass
    public void findNillableProperties(ITestContext testContext) {
        this.nillableProperties = new HashMap<QName, List<XSElementDeclaration>>();
        ListIterator typesItr = this.featureTypes.listIterator();
        while (typesItr.hasNext()) {
            QName typeName = (QName)typesItr.next();
            TestSuiteLogger.log((Level)Level.FINE, (String)("Checking feature type for nillable properties: " + typeName));
            List<XSElementDeclaration> nillableProps = AppSchemaUtils.getNillableProperties(this.model, typeName);
            TestSuiteLogger.log((Level)Level.FINE, (String)nillableProps.toString());
            FeatureTypeInfo typeInfo = this.dataSampler.getFeatureTypeInfo().get(typeName);
            if (!typeInfo.isInstantiated() || nillableProps.size() <= 1) continue;
            this.nillableProperties.put(typeName, nillableProps);
        }
    }

    @Test(description="See ISO 19143: 7.7.3.6, A.6", dataProvider="protocol-binding")
    public void propertyIsNil(ProtocolBinding binding) {
        if (this.nillableProperties.isEmpty()) {
            throw new AssertionError((Object)ErrorMessage.format("CapabilityNotTested", "PropertyIsNil", "No feature type for which instances exist has nillable properties"));
        }
        for (QName typeName : this.nillableProperties.keySet()) {
            List<XSElementDeclaration> nillables = this.nillableProperties.get(typeName);
            WFSRequest.appendSimpleQuery(this.reqEntity, typeName);
            XSElementDeclaration prop = nillables.get(nillables.size() - 1);
            QName propName = new QName(prop.getNamespace(), prop.getName());
            this.addPropertyIsNilPredicate(this.reqEntity, propName, null, false);
            ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
            this.rspEntity = this.extractBodyAsDocument(rsp, binding);
            Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
            NodeList features = this.rspEntity.getElementsByTagNameNS(typeName.getNamespaceURI(), typeName.getLocalPart());
            String xpath = String.format("ns1:%s[@xsi:nil='true']", propName.getLocalPart());
            HashMap<String, String> nsBindings = new HashMap<String, String>();
            nsBindings.put(propName.getNamespaceURI(), "ns1");
            for (int i = 0; i < features.getLength(); ++i) {
                ETSAssert.assertXPath(xpath, features.item(i), nsBindings);
            }
        }
    }

    void addPropertyIsNilPredicate(Document request, QName propertyName, String nilReason, boolean negate) {
        if (!request.getDocumentElement().getLocalName().equals("GetFeature")) {
            throw new IllegalArgumentException("Not a GetFeature request: " + request.getDocumentElement().getNodeName());
        }
        if (null == propertyName) {
            throw new IllegalArgumentException("propertyName is required.");
        }
        Element queryElem = (Element)request.getElementsByTagNameNS("http://www.opengis.net/wfs/2.0", "Query").item(0);
        Element filter = request.createElementNS("http://www.opengis.net/fes/2.0", "Filter");
        queryElem.appendChild(filter);
        Element predicate = request.createElementNS("http://www.opengis.net/fes/2.0", "PropertyIsNil");
        if (null != nilReason && !nilReason.isEmpty()) {
            predicate.setAttribute("nilReason", nilReason);
        }
        if (negate) {
            Element not = request.createElementNS("http://www.opengis.net/fes/2.0", "Not");
            filter.appendChild(not);
            not.appendChild(predicate);
        } else {
            filter.appendChild(predicate);
        }
        Element valueRef = request.createElementNS("http://www.opengis.net/fes/2.0", "ValueReference");
        predicate.appendChild(valueRef);
        String prefix = propertyName.getPrefix().length() > 0 ? propertyName.getPrefix() : "tns";
        String nsURI = request.lookupNamespaceURI(prefix);
        if (null == nsURI) {
            valueRef.setAttribute("xmlns:" + prefix, propertyName.getNamespaceURI());
        }
        valueRef.setTextContent(prefix + ":" + propertyName.getLocalPart());
    }
}

