/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.basic.filter;

import com.sun.jersey.api.client.ClientResponse;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import javax.xml.namespace.QName;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.basic.filter.QueryFilterFixture;
import org.opengis.cite.iso19142.util.WFSRequest;
import org.testng.Assert;
import org.testng.SkipException;
import org.testng.annotations.Test;

public class ResourceIdFilterTests
extends QueryFilterFixture {
    @Test(description="See ISO 19142: 7.2.2; ISO 19143: 7.11", dataProvider="protocol-featureType")
    public void twoValidFeatureIdentifiers(ProtocolBinding binding, QName featureType) {
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        Set<String> idSet = this.dataSampler.selectRandomFeatureIdentifiers(featureType, 2);
        WFSRequest.addResourceIdPredicate(this.reqEntity, idSet);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        ETSAssert.assertDescendantElementCount(this.rspEntity, featureType, idSet.size());
    }

    @Test(description="See ISO 19142: 7.2.2, Table 8", dataProvider="protocol-featureType")
    public void unknownFeatureIdentifier(ProtocolBinding binding, QName featureType) {
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        HashSet<String> idSet = new HashSet<String>();
        idSet.add("test-" + UUID.randomUUID());
        WFSRequest.addResourceIdPredicate(this.reqEntity, idSet);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        ETSAssert.assertQualifiedName(this.rspEntity.getDocumentElement(), new QName("http://www.opengis.net/wfs/2.0", "FeatureCollection"));
        ETSAssert.assertFeatureCount(this.rspEntity, featureType, 0);
    }

    @Test(description="See ISO 19142: 7.9.2.4.1", dataProvider="protocol-featureType")
    public void inconsistentFeatureIdentifierAndType(ProtocolBinding binding, QName featureType) {
        WFSRequest.appendSimpleQuery(this.reqEntity, featureType);
        HashSet<String> idSet = new HashSet<String>();
        String featureId = this.dataSampler.getFeatureId(featureType, false);
        if (null == featureId) {
            throw new SkipException("Unable to find id of feature instance that is NOT of type " + featureType);
        }
        idSet.add(featureId);
        WFSRequest.addResourceIdPredicate(this.reqEntity, idSet);
        ClientResponse rsp = this.wfsClient.submitRequest(this.reqEntity, binding);
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        ETSAssert.assertExceptionReport(this.rspEntity, "InvalidParameterValue", "RESOURCEID");
    }
}

