/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.simple;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.io.InputStream;
import java.net.URI;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.opengis.cite.iso19142.BaseFixture;
import org.opengis.cite.iso19142.ETSAssert;
import org.opengis.cite.iso19142.ErrorMessage;
import org.opengis.cite.iso19142.ProtocolBinding;
import org.opengis.cite.iso19142.SuiteAttribute;
import org.opengis.cite.iso19142.util.ServiceMetadataUtils;
import org.opengis.cite.iso19142.util.ValidationUtils;
import org.opengis.cite.iso19142.util.XMLUtils;
import org.opengis.cite.validation.SchematronValidator;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class SimpleCapabilitiesTests
extends BaseFixture {
    private URI reqEndpointUsingGET;
    private Client client;

    @BeforeTest
    public void checkSuitePreconditions(ITestContext context) {
        Object failedPreconditions = context.getSuite().getAttribute(SuiteAttribute.FAILED_PRECONDITIONS.getName());
        if (null != failedPreconditions) {
            throw new SkipException("One or more test suite preconditions were not satisfied: " + failedPreconditions);
        }
    }

    @BeforeClass
    public void extractEndpoint(ITestContext testContext) {
        this.client = Client.create();
        this.reqEndpointUsingGET = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetCapabilities", ProtocolBinding.GET);
    }

    @Test(description="See ISO 19142: 7.5")
    public void getCapabilities_missingServiceParam() {
        WebResource resource = this.client.resource(this.reqEndpointUsingGET).queryParam("request", "GetCapabilities");
        resource.accept(new String[]{"application/xml"});
        ClientResponse rsp = (ClientResponse)resource.get(ClientResponse.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        SchematronValidator validator = ValidationUtils.buildSchematronValidator("ExceptionReport.sch", "MissingParameterValuePhase");
        DOMResult result = validator.validate((Source)new DOMSource(this.rspEntity));
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }

    @Test(description="See ISO 19142: 7.2")
    public void getFullCapabilities() {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putSingle((Object)"request", (Object)"GetCapabilities");
        params.putSingle((Object)"service", (Object)"WFS");
        WebResource resource = this.client.resource(this.reqEndpointUsingGET).queryParams((MultivaluedMap)params);
        resource.accept(new String[]{"application/xml"});
        ClientResponse rsp = (ClientResponse)resource.get(ClientResponse.class);
        Assert.assertEquals((int)rsp.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        this.rspEntity = (Document)rsp.getEntity(Document.class);
        Assert.assertNotNull((Object)this.rspEntity, (String)ErrorMessage.get("MissingXMLEntity"));
        SchematronValidator validator = ValidationUtils.buildSchematronValidator("wfs-capabilities-2.0.sch", "SimpleWFSPhase");
        DOMResult result = validator.validate((Source)new DOMSource(this.rspEntity, this.rspEntity.getDocumentURI()));
        Assert.assertFalse((boolean)validator.ruleViolationsDetected(), (String)ErrorMessage.format("NotSchemaValid", validator.getRuleViolationCount(), XMLUtils.writeNodeToString(result.getNode())));
    }

    @Test(description="See ISO 19142: 7.2, 7.3.2", dataProvider="protocol-binding")
    public void getCapabilities_acceptVersions(ProtocolBinding binding) {
        InputStream entityStream = this.getClass().getResourceAsStream("getCapabilities_acceptVersions.xml");
        URI endpoint = ServiceMetadataUtils.getOperationEndpoint(this.wfsMetadata, "GetCapabilities", binding);
        ClientResponse rsp = this.wfsClient.submitRequest(new StreamSource(entityStream), binding, endpoint);
        Assert.assertTrue((boolean)rsp.hasEntity(), (String)ErrorMessage.get("MissingXMLEntity"));
        this.rspEntity = this.extractBodyAsDocument(rsp, binding);
        String xpath = "/wfs:WFS_Capabilities/@version = '2.0.0'";
        ETSAssert.assertXPath(xpath, this.rspEntity.getDocumentElement(), null);
    }
}

