/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.iso19142.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import javax.xml.namespace.QName;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTypeDefinition;
import org.opengis.cite.iso19136.util.XMLSchemaModelUtils;
import org.opengis.cite.iso19142.util.TestSuiteLogger;

public class AppSchemaUtils {
    public static List<XSElementDeclaration> getFeaturePropertiesByType(XSModel model, QName featureTypeName, XSTypeDefinition typeDef) {
        XSElementDeclaration elemDecl = model.getElementDeclaration(featureTypeName.getLocalPart(), featureTypeName.getNamespaceURI());
        XSComplexTypeDefinition featureTypeDef = (XSComplexTypeDefinition)elemDecl.getTypeDefinition();
        List featureProps = XMLSchemaModelUtils.getAllElementsInParticle((XSParticle)featureTypeDef.getParticle());
        AppSchemaUtils.removeDeprecatedGMLElements(featureProps, model);
        ArrayList<XSElementDeclaration> props = new ArrayList<XSElementDeclaration>();
        short extendOrRestrict = 3;
        block4: for (XSElementDeclaration featureProp : featureProps) {
            XSTypeDefinition propType = featureProp.getTypeDefinition();
            switch (propType.getTypeCategory()) {
                case 16: {
                    if (typeDef.getTypeCategory() != 16 || !propType.derivedFromType(typeDef, extendOrRestrict)) break;
                    props.add(featureProp);
                    break;
                }
                case 15: {
                    if (typeDef.getTypeCategory() == 15) {
                        XSComplexTypeDefinition complexPropType = (XSComplexTypeDefinition)propType;
                        List propValues = XMLSchemaModelUtils.getAllElementsInParticle((XSParticle)complexPropType.getParticle());
                        for (XSElementDeclaration propValue : propValues) {
                            if (!propValue.getTypeDefinition().derivedFromType(typeDef, extendOrRestrict)) continue;
                            props.add(featureProp);
                        }
                        continue block4;
                    }
                    if (!propType.derivedFromType(typeDef, extendOrRestrict)) break;
                    props.add(featureProp);
                }
            }
        }
        if (TestSuiteLogger.isLoggable(Level.FINER)) {
            TestSuiteLogger.log(Level.FINER, "In feature type defn " + featureTypeDef.getName() + ", found properties with value of type " + typeDef.getName() + "\n" + props);
        }
        return props;
    }

    public static List<XSElementDeclaration> getNillableProperties(XSModel model, QName featureTypeName) {
        List<XSElementDeclaration> featureProps = AppSchemaUtils.getAllFeatureProperties(model, featureTypeName);
        Iterator<XSElementDeclaration> itr = featureProps.iterator();
        while (itr.hasNext()) {
            XSElementDeclaration prop = itr.next();
            if (prop.getNillable()) continue;
            itr.remove();
        }
        return featureProps;
    }

    public static List<XSElementDeclaration> getAllFeatureProperties(XSModel model, QName featureTypeName) {
        XSElementDeclaration elemDecl = model.getElementDeclaration(featureTypeName.getLocalPart(), featureTypeName.getNamespaceURI());
        XSComplexTypeDefinition featureTypeDef = (XSComplexTypeDefinition)elemDecl.getTypeDefinition();
        return XMLSchemaModelUtils.getAllElementsInParticle((XSParticle)featureTypeDef.getParticle());
    }

    public static List<XSElementDeclaration> getSimpleFeatureProperties(XSModel model, QName featureTypeName) {
        XSElementDeclaration elemDecl = model.getElementDeclaration(featureTypeName.getLocalPart(), featureTypeName.getNamespaceURI());
        XSComplexTypeDefinition featureTypeDef = (XSComplexTypeDefinition)elemDecl.getTypeDefinition();
        List props = XMLSchemaModelUtils.getAllElementsInParticle((XSParticle)featureTypeDef.getParticle());
        Iterator propsItr = props.iterator();
        while (propsItr.hasNext()) {
            XSComplexTypeDefinition typeDef;
            XSElementDeclaration prop = (XSElementDeclaration)propsItr.next();
            if (prop.getNamespace().equals("http://www.opengis.net/gml/3.2")) {
                propsItr.remove();
                continue;
            }
            if (prop.getTypeDefinition().getTypeCategory() != 15 || null != (typeDef = (XSComplexTypeDefinition)prop.getTypeDefinition()).getSimpleType()) continue;
            propsItr.remove();
        }
        return props;
    }

    public static List<XSElementDeclaration> getRequiredProperties(XSModel model, QName featureTypeName) {
        XSElementDeclaration elemDecl = model.getElementDeclaration(featureTypeName.getLocalPart(), featureTypeName.getNamespaceURI());
        XSComplexTypeDefinition typeDef = (XSComplexTypeDefinition)elemDecl.getTypeDefinition();
        List particles = XMLSchemaModelUtils.getAllElementParticles((XSParticle)typeDef.getParticle());
        ArrayList<XSElementDeclaration> requiredElems = new ArrayList<XSElementDeclaration>();
        for (XSParticle particle : particles) {
            if (particle.getMinOccurs() <= 0) continue;
            XSElementDeclaration elem = (XSElementDeclaration)particle.getTerm();
            requiredElems.add(elem);
        }
        return requiredElems;
    }

    public static void removeDeprecatedGMLElements(List<XSElementDeclaration> elemDecls, XSModel model) {
        XSElementDeclaration elemDecl = model.getElementDeclaration("location", "http://www.opengis.net/gml/3.2");
        elemDecls.remove(elemDecl);
        elemDecl = model.getElementDeclaration("metaDataProperty", "http://www.opengis.net/gml/3.2");
        elemDecls.remove(elemDecl);
    }

    public static QName getBuiltInDatatype(XSElementDeclaration propDecl) {
        short builtInType;
        XSTypeDefinition typeDef = propDecl.getTypeDefinition();
        if (typeDef.getTypeCategory() == 16) {
            XSSimpleTypeDefinition simpleType = (XSSimpleTypeDefinition)typeDef;
            builtInType = simpleType.getBuiltInKind();
        } else {
            XSComplexTypeDefinition complexType = (XSComplexTypeDefinition)typeDef;
            builtInType = complexType.getSimpleType().getBuiltInKind();
        }
        QName datatype = null;
        switch (builtInType) {
            case 6: {
                datatype = new QName("http://www.w3.org/2001/XMLSchema", "double");
                break;
            }
            case 5: {
                datatype = new QName("http://www.w3.org/2001/XMLSchema", "float");
                break;
            }
            case 4: {
                datatype = new QName("http://www.w3.org/2001/XMLSchema", "decimal");
                break;
            }
            case 30: {
                datatype = new QName("http://www.w3.org/2001/XMLSchema", "integer");
                break;
            }
            case 2: {
                datatype = new QName("http://www.w3.org/2001/XMLSchema", "string");
                break;
            }
            case 8: {
                datatype = new QName("http://www.w3.org/2001/XMLSchema", "dateTime");
                break;
            }
            case 10: {
                datatype = new QName("http://www.w3.org/2001/XMLSchema", "date");
                break;
            }
            case 3: {
                datatype = new QName("http://www.w3.org/2001/XMLSchema", "boolean");
                break;
            }
            default: {
                datatype = new QName("http://www.w3.org/2001/XMLSchema", "anySimpleType");
            }
        }
        return datatype;
    }
}

