/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.CheckedOutputStream;
import java.util.zip.Checksum;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.geotoolkit.internal.io.IOUtilities;
import org.geotoolkit.lang.Static;
import org.geotoolkit.util.ArgumentChecks;
import org.geotoolkit.util.logging.Logging;

public final class FileUtilities
extends Static {
    private static final Logger LOGGER = Logging.getLogger(FileUtilities.class);
    private static final int BUFFER = 2048;

    private FileUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File src, File dest) throws IOException {
        if (src == null || dest == null) {
            LOGGER.warning("Source and destination files must not be null for the copy");
            return;
        }
        if (!src.exists()) {
            LOGGER.log(Level.WARNING, "The source file does not exist: {0}", src);
            return;
        }
        if (src.isDirectory()) {
            if (!dest.exists() && !dest.mkdir()) {
                throw new IOException("Failed to create directory : " + dest);
            }
            String[] files = src.list();
            for (int i = 0; i < files.length; ++i) {
                FileUtilities.copy(new File(src, files[i]), new File(dest, files[i]));
            }
        } else {
            FileInputStream from = null;
            FileOutputStream to = null;
            try {
                int bytesRead;
                from = new FileInputStream(src);
                to = new FileOutputStream(dest);
                byte[] buffer = new byte[4096];
                while ((bytesRead = from.read(buffer)) != -1) {
                    to.write(buffer, 0, bytesRead);
                }
            }
            finally {
                if (from != null) {
                    try {
                        from.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                if (to != null) {
                    try {
                        to.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
            }
        }
    }

    public static boolean deleteDirectory(File dir) {
        if (dir.isDirectory()) {
            for (File f : dir.listFiles()) {
                FileUtilities.deleteDirectory(f);
            }
        }
        return dir.delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void appendToFile(String text, String urlFile) throws IOException {
        FileWriter fw = new FileWriter(urlFile, true);
        BufferedWriter output = new BufferedWriter(fw);
        try {
            output.write(text);
            output.newLine();
            output.flush();
        }
        finally {
            output.close();
        }
    }

    public static void emptyFile(String urlFile) throws IOException {
        File file = new File(urlFile);
        if (file.exists() && !file.delete()) {
            throw new IOException("Failed to delete file : " + file);
        }
        if (!file.createNewFile()) {
            throw new IOException("Failed to create file : " + file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromFile(File f) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new FileReader(f));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        finally {
            br.close();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getStringFromStream(InputStream stream) throws IOException {
        StringBuilder sb = new StringBuilder();
        BufferedReader br = new BufferedReader(new InputStreamReader(stream, "UTF-8"));
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append('\n');
            }
        }
        finally {
            br.close();
            stream.close();
        }
        return sb.toString();
    }

    public static File getDirectoryFromResource(String packagee) {
        File result = null;
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try {
            String fileP = packagee.replace('.', '/');
            Enumeration<URL> urls = classloader.getResources(fileP);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try {
                    URI uri = url.toURI();
                    result = FileUtilities.scanDir(uri, fileP);
                }
                catch (URISyntaxException e) {
                    LOGGER.log(Level.SEVERE, "URL, {0}cannot be converted to a URI", url);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "The resources for the package{0}, could not be obtained.\nCause:{1}", new Object[]{packagee, ex.getMessage()});
        }
        return result;
    }

    public static File getFileFromResource(String packagee) {
        File result = null;
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try {
            String extension = packagee.substring(packagee.lastIndexOf(46), packagee.length());
            packagee = packagee.substring(0, packagee.lastIndexOf(46));
            String fileP = packagee.replace('.', '/') + extension;
            Enumeration<URL> urls = classloader.getResources(fileP);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try {
                    URI uri = url.toURI();
                    result = FileUtilities.scanFile(uri, fileP);
                }
                catch (URISyntaxException e) {
                    LOGGER.log(Level.SEVERE, "URL, {0}cannot be converted to a URI", url);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "The resources for the package{0}, could not be obtained.\nCause:{1}", new Object[]{packagee, ex.getMessage()});
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File buildFileFromStream(InputStream in, File dest) throws IOException {
        if (in != null && dest != null) {
            FileOutputStream fos = new FileOutputStream(dest);
            try {
                int bytesRead;
                byte[] buffer = new byte[4096];
                while ((bytesRead = in.read(buffer)) != -1) {
                    fos.write(buffer, 0, bytesRead);
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                    }
                }
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
                }
            }
            return dest;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getPropertiesFromFile(File f) throws IOException {
        if (f != null) {
            Properties prop = new Properties();
            if (f.exists()) {
                FileInputStream in = new FileInputStream(f);
                try {
                    prop.load(in);
                }
                finally {
                    in.close();
                }
            } else if (!f.createNewFile()) {
                throw new IOException("Failed to create file : " + f);
            }
            return prop;
        }
        throw new IllegalArgumentException(" the properties file can't be null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(Properties prop, File f) throws IOException {
        if (prop == null || f == null) {
            throw new IllegalArgumentException(" the properties or file can't be null");
        }
        FileOutputStream out = new FileOutputStream(f);
        try {
            prop.store(out, "");
        }
        finally {
            out.close();
        }
    }

    public static File scanDir(URI u, String filePackageName) throws IOException {
        String scheme = u.getScheme();
        if ("file".equals(scheme)) {
            File f = new File(u.getPath());
            if (f.isDirectory()) {
                return f;
            }
        } else if ("jar".equals(scheme) || "zip".equals(scheme)) {
            File f = new File(System.getProperty("java.io.tmpdir") + "/Constellation");
            boolean created = true;
            if (!f.exists()) {
                created = f.mkdir();
            }
            if (created) {
                try {
                    String cleanedUri = u.getSchemeSpecificPart();
                    if (cleanedUri.indexOf(33) != -1) {
                        cleanedUri = cleanedUri.substring(0, cleanedUri.indexOf(33));
                    }
                    URI newUri = new URI(cleanedUri);
                    InputStream i = newUri.toURL().openStream();
                    IOUtilities.unzip((InputStream)i, (File)f);
                }
                catch (URISyntaxException ex) {
                    LOGGER.log(Level.WARNING, null, ex);
                }
                File fConfig = new File(f, filePackageName);
                if (fConfig.exists() && fConfig.isDirectory()) {
                    return fConfig;
                }
                LOGGER.info("The configuration directory was not found in the temporary folder.");
            } else {
                LOGGER.info("The Constellation directory can't be created in the temporary folder.");
            }
        }
        return null;
    }

    public static File scanFile(URI u, String filePackageName) throws IOException {
        String scheme = u.getScheme();
        if ("file".equals(scheme)) {
            return new File(u.getPath());
        }
        if ("jar".equals(scheme) || "zip".equals(scheme)) {
            File f = new File(System.getProperty("java.io.tmpdir") + "/Constellation");
            boolean created = true;
            if (!f.exists()) {
                created = f.mkdir();
            }
            if (created) {
                File fConfig = new File(f, filePackageName);
                if (fConfig.exists() && fConfig.isDirectory()) {
                    return fConfig;
                }
                LOGGER.info("The configuration directory was not found in the temporary folder.");
            } else {
                LOGGER.info("The Constellation directory can't be created in the temporary folder.");
            }
        }
        return null;
    }

    public static List<String> searchSubFiles(String packagee) {
        ArrayList<String> result = new ArrayList<String>();
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        try {
            String fileP = packagee.replace('.', '/');
            Enumeration<URL> urls = classloader.getResources(fileP);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                try {
                    URI uri = url.toURI();
                    result.addAll(FileUtilities.scan(uri, fileP, false));
                }
                catch (URISyntaxException e) {
                    LOGGER.log(Level.SEVERE, "URL, {0}cannot be converted to a URI", url);
                }
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.SEVERE, "The resources for the package {0}, could not be obtained. \ncause:{1}", new Object[]{packagee, ex.getMessage()});
        }
        return result;
    }

    public static List<String> searchSubPackage(String ... packages) {
        ArrayList<String> result = new ArrayList<String>();
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        for (String p : packages) {
            try {
                String fileP = p.replace('.', '/');
                Enumeration<URL> urls = classloader.getResources(fileP);
                while (urls.hasMoreElements()) {
                    URL url = urls.nextElement();
                    try {
                        URI uri = url.toURI();
                        List<String> scanned = FileUtilities.scan(uri, fileP, true);
                        for (String s : scanned) {
                            if (result.contains(s)) continue;
                            result.add(s);
                        }
                    }
                    catch (URISyntaxException e) {
                        LOGGER.log(Level.SEVERE, "URL, {0} cannot be converted to a URI", url);
                    }
                }
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, "The resources for the package" + p + ", could not be obtained.", ex);
            }
        }
        return result;
    }

    public static List<String> scan(URI u, String filePackageName, boolean directory) throws IOException {
        ArrayList<String> result;
        block6: {
            String scheme;
            block4: {
                File f;
                block5: {
                    result = new ArrayList<String>();
                    scheme = u.getScheme();
                    if (!"file".equals(scheme)) break block4;
                    f = new File(u.getPath());
                    if (!f.isDirectory()) break block5;
                    List<String> scanned = FileUtilities.scanDirectory(f, filePackageName, directory);
                    for (String s : scanned) {
                        if (result.contains(s)) continue;
                        result.add(s);
                    }
                    break block6;
                }
                if (directory) break block6;
                result.add(f.getPath());
                break block6;
            }
            if (!"jar".equals(scheme) && !"zip".equals(scheme)) break block6;
            try {
                String brut = u.getSchemeSpecificPart();
                URI uri = URI.create(brut.replaceAll(" ", "%20"));
                String jarFile = uri.getPath();
                jarFile = jarFile.substring(0, jarFile.indexOf(33));
                List<String> scanned = FileUtilities.scanJar(new File(jarFile), filePackageName, directory);
                for (String s : scanned) {
                    if (result.contains(s)) continue;
                    result.add(s);
                }
            }
            catch (IllegalArgumentException ex) {
                LOGGER.log(Level.WARNING, "unable to scan jar file: {0}\n cause:{1}", new Object[]{u.getSchemeSpecificPart(), ex.getMessage()});
            }
        }
        return result;
    }

    public static List<String> scanDirectory(File root, String parent, boolean directory) {
        ArrayList<String> result = new ArrayList<String>();
        for (File child : root.listFiles()) {
            if (child.isDirectory()) {
                String s;
                if (directory && !result.contains(s = parent.replace('/', '.') + '.' + child.getName())) {
                    result.add(s);
                }
                List<String> scanned = FileUtilities.scanDirectory(child, parent, directory);
                for (String s2 : scanned) {
                    if (result.contains(s2)) continue;
                    result.add(s2);
                }
                continue;
            }
            if (directory || result.contains(child.getPath())) continue;
            result.add(child.getPath());
        }
        return result;
    }

    public static List<String> scanJar(File file, String parent, boolean directory) throws IOException {
        ArrayList<String> result = new ArrayList<String>();
        JarFile jar = new JarFile(file);
        Enumeration<JarEntry> entries = jar.entries();
        while (entries.hasMoreElements()) {
            String s;
            JarEntry e = entries.nextElement();
            if (e.isDirectory() && e.getName().startsWith(parent) && directory) {
                s = e.getName().replace('/', '.');
                if (result.contains(s = s.substring(0, s.length() - 1))) continue;
                result.add(s);
                continue;
            }
            if (e.isDirectory() || !e.getName().startsWith(parent) || directory) continue;
            s = e.getName().replace('/', '.');
            if (result.contains(s = s.substring(0, s.length() - 1))) continue;
            result.add(s);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stringToFile(File f, String s) throws IOException {
        BufferedWriter bw = new BufferedWriter(new FileWriter(f));
        try {
            bw.write(s);
        }
        finally {
            bw.close();
        }
    }

    public static void zip(Object zip, Checksum checksum, Object ... resources) throws IOException {
        FileUtilities.zip(zip, 0, 0, checksum, resources);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void zip(Object zip, int method, int level, Checksum checksum, Object ... resources) throws IOException {
        BufferedOutputStream buf;
        if (checksum != null) {
            CheckedOutputStream cos = new CheckedOutputStream(FileUtilities.toOutputStream(zip), checksum);
            buf = new BufferedOutputStream(cos);
        } else {
            buf = new BufferedOutputStream(FileUtilities.toOutputStream(zip));
        }
        ZipOutputStream zout = new ZipOutputStream(buf);
        try {
            zout.setMethod(method);
            zout.setLevel(level);
            FileUtilities.zipCore(zout, method, level, "", resources);
        }
        finally {
            zout.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void zipCore(ZipOutputStream zout, int method, int level, String entryPath, Object ... resources) throws IOException {
        byte[] data = new byte[2048];
        CRC32 crc = new CRC32();
        boolean stored = false;
        if (0 == method) {
            stored = true;
            for (Object resource : resources) {
                if (resource instanceof File) continue;
                throw new IllegalArgumentException("This compression is supported with File resources only.");
            }
        } else if (8 != method) {
            throw new IllegalArgumentException("This compression method is not supported.");
        }
        if (Double.isNaN(level) || Double.isInfinite(level) || level > 9 || level < 0) {
            throw new IllegalArgumentException("Illegal compression level.");
        }
        for (int i = 0; i < resources.length; ++i) {
            ZipEntry entry = new ZipEntry(entryPath + FileUtilities.getFileName(resources[i]));
            if (stored) {
                File file = (File)resources[i];
                entry.setCompressedSize(file.length());
                entry.setSize(file.length());
                entry.setCrc(crc.getValue());
            }
            if (resources[i] instanceof File && ((File)resources[i]).isDirectory()) {
                String zipName = entryPath + ((File)resources[i]).getName() + (((File)resources[i]).isDirectory() ? Character.valueOf('/') : "");
                FileUtilities.zipCore(zout, method, level, zipName, ((File)resources[i]).listFiles());
                continue;
            }
            zout.putNextEntry(entry);
            BufferedInputStream buffi = new BufferedInputStream(FileUtilities.toInputStream(resources[i]), 2048);
            if (stored) {
                try {
                    int bytesRead;
                    crc.reset();
                    while ((bytesRead = buffi.read(data, 0, 2048)) != -1) {
                        crc.update(data, 0, bytesRead);
                    }
                }
                finally {
                    buffi.close();
                }
                buffi = new BufferedInputStream(FileUtilities.toInputStream(resources[i]), 2048);
            }
            try {
                int count;
                while (-1 != (count = buffi.read(data, 0, 2048))) {
                    zout.write(data, 0, count);
                }
                continue;
            }
            finally {
                zout.closeEntry();
                buffi.close();
            }
        }
    }

    public static List<File> unzip(Object zip, Checksum checksum) throws IOException {
        return FileUtilities.unzip(zip, FileUtilities.getParent(zip), checksum);
    }

    public static List<File> unzip(Object zip, Object resource, Checksum checksum) throws IOException {
        BufferedInputStream buffi;
        if (checksum != null) {
            CheckedInputStream cis = new CheckedInputStream(FileUtilities.toInputStream(zip), checksum);
            buffi = new BufferedInputStream(cis);
        } else {
            buffi = new BufferedInputStream(FileUtilities.toInputStream(zip));
        }
        return FileUtilities.unzipCore(buffi, resource);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> unzipCore(InputStream zip, Object resource) throws IOException {
        byte[] data = new byte[2048];
        ZipInputStream zis = new ZipInputStream(zip);
        ArrayList<File> unzipped = new ArrayList<File>();
        try {
            ZipEntry entry;
            String extractPath = FileUtilities.getPath(resource);
            while ((entry = zis.getNextEntry()) != null) {
                File file = new File(extractPath, entry.getName());
                if (entry.isDirectory()) {
                    file.mkdirs();
                    continue;
                }
                file.getParentFile().mkdirs();
                unzipped.add(file);
                OutputStream fos = FileUtilities.toOutputStream(file);
                BufferedOutputStream dest = new BufferedOutputStream(fos, 2048);
                try {
                    int count;
                    while ((count = zis.read(data, 0, 2048)) != -1) {
                        dest.write(data, 0, count);
                    }
                    dest.flush();
                }
                finally {
                    dest.close();
                }
            }
        }
        finally {
            zis.close();
        }
        return unzipped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<File> unZipFileList(InputStream is) {
        ZipInputStream in = null;
        ArrayList<File> files = new ArrayList<File>();
        try {
            ZipEntry zi;
            in = new ZipInputStream(is);
            while ((zi = in.getNextEntry()) != null) {
                if (zi.isDirectory()) continue;
                String fileName = FileUtilities.removeDirectory(zi.getName());
                String fileExt = FileUtilities.extractExtension(zi.getName());
                String suffix = "." + (fileExt != null ? fileExt : "tmp");
                File f = File.createTempFile(fileName, suffix);
                FileOutputStream out = new FileOutputStream(f);
                int c = 0;
                while ((c = in.read()) != -1) {
                    out.write(c);
                }
                out.close();
                files.add(f);
            }
            in.close();
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        catch (IOException ex) {
            LOGGER.log(Level.WARNING, null, ex);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {
                LOGGER.log(Level.WARNING, null, ex);
            }
        }
        return files;
    }

    private static String removeDirectory(String fileName) {
        int index = fileName.lastIndexOf(47);
        int dotIndex = fileName.lastIndexOf(46);
        if (index != -1) {
            if (dotIndex != -1) {
                return fileName.substring(index + 1, dotIndex);
            }
            return fileName.substring(index + 1);
        }
        return fileName;
    }

    private static String extractExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(46);
        if (dotIndex != -1) {
            return fileName.substring(dotIndex + 1);
        }
        return null;
    }

    private static String getUnicFileName(String fileName, List<String> fileNames) {
        int i = 0;
        String newName = fileName + i;
        while (fileNames.contains(newName)) {
            newName = newName.substring(0, newName.length() - 1);
            newName = newName + ++i;
        }
        return newName;
    }

    private static OutputStream toOutputStream(Object resource) throws IOException {
        ArgumentChecks.ensureNonNull((String)"resource", (Object)resource);
        OutputStream fot = null;
        if (resource instanceof File) {
            fot = new FileOutputStream((File)resource);
        } else if (resource instanceof String) {
            fot = new FileOutputStream(new File((String)resource));
        } else if (resource instanceof OutputStream) {
            fot = (OutputStream)resource;
        } else if (resource != null) {
            throw new IllegalArgumentException("This argument must be instance of File, String (representing a path) or OutputStream.");
        }
        return fot;
    }

    private static InputStream toInputStream(Object resource) throws IOException {
        ArgumentChecks.ensureNonNull((String)"resource", (Object)resource);
        InputStream fit = null;
        if (resource instanceof File) {
            fit = new FileInputStream((File)resource);
        } else if (resource instanceof URL) {
            fit = ((URL)resource).openStream();
        } else if (resource instanceof URI) {
            fit = ((URI)resource).toURL().openStream();
        } else if (resource instanceof String) {
            fit = new FileInputStream(new File((String)resource));
        } else if (resource instanceof InputStream) {
            fit = (InputStream)resource;
        } else if (resource != null) {
            throw new IllegalArgumentException("This argument must be instance of File, String (representing a path), URL, URI or InputStream.");
        }
        return fit;
    }

    private static String getPath(Object resource) throws MalformedURLException {
        String extractPath = null;
        if (resource instanceof File) {
            extractPath = ((File)resource).getPath();
        } else if (resource instanceof URL) {
            extractPath = ((URL)resource).getPath();
        } else if (resource instanceof URI) {
            extractPath = ((URI)resource).toURL().getPath();
        } else if (resource instanceof String) {
            extractPath = (String)resource;
        }
        return extractPath;
    }

    private static String getParent(Object resource) throws MalformedURLException {
        String extractPath = null;
        if (resource instanceof File) {
            extractPath = ((File)resource).getParent();
        } else {
            extractPath = FileUtilities.getPath(resource);
            extractPath = extractPath.substring(0, extractPath.lastIndexOf(File.separator) + 1);
        }
        return extractPath;
    }

    private static String getFileName(Object resource) throws MalformedURLException {
        String fileName = null;
        if (resource instanceof File) {
            fileName = ((File)resource).getName();
        } else {
            fileName = FileUtilities.getPath(resource);
            fileName = fileName.substring(fileName.lastIndexOf(File.separator) + 1, fileName.length());
        }
        return fileName;
    }
}

