/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.opensearch;

import com.sun.jersey.api.client.ClientResponse;
import java.net.URI;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.geotoolkit.geometry.Envelopes;
import org.geotoolkit.geometry.GeneralEnvelope;
import org.geotoolkit.referencing.crs.DefaultGeographicCRS;
import org.opengis.cite.cat30.CommonFixture;
import org.opengis.cite.cat30.ETSAssert;
import org.opengis.cite.cat30.ErrorMessage;
import org.opengis.cite.cat30.SuiteAttribute;
import org.opengis.cite.cat30.util.ClientUtils;
import org.opengis.cite.cat30.util.DatasetInfo;
import org.opengis.cite.cat30.util.OpenSearchTemplateUtils;
import org.opengis.cite.cat30.util.ServiceMetadataUtils;
import org.opengis.cite.cat30.util.URIUtils;
import org.opengis.cite.geomatics.Extents;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.testng.Assert;
import org.testng.ITestContext;
import org.testng.SkipException;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenSearchGeoTests
extends CommonFixture {
    static final QName UID_PARAM = new QName("http://a9.com/-/opensearch/extensions/geo/1.0/", "uid");
    private Document openSearchDescr;
    private List<Node> urlTemplates;
    private List<String> idList;
    private Envelope geoExtent;

    @BeforeClass
    public void initOpenSearchGeoTestsFixture(ITestContext testContext) {
        this.openSearchDescr = (Document)testContext.getSuite().getAttribute(SuiteAttribute.OPENSEARCH_DESCR.getName());
        if (null == this.openSearchDescr) {
            throw new SkipException("OpenSearch description not found in test context.");
        }
        this.urlTemplates = ServiceMetadataUtils.getOpenSearchURLTemplates(this.openSearchDescr);
        DatasetInfo dataset = (DatasetInfo)testContext.getSuite().getAttribute(SuiteAttribute.DATASET.getName());
        if (null == dataset) {
            throw new SkipException("Dataset info not found in test context.");
        }
        this.idList = dataset.getRecordIdentifiers();
        this.geoExtent = dataset.getGeographicExtent();
    }

    @Test(description="Requirement-141")
    public void getResourceById_notFound() {
        QName uidParam = new QName("http://a9.com/-/opensearch/extensions/geo/1.0/", "uid");
        List<Node> uidTemplates = OpenSearchTemplateUtils.filterURLTemplatesByParam(this.urlTemplates, uidParam);
        Assert.assertFalse((boolean)uidTemplates.isEmpty(), (String)"No URL templates containing {geo:uid} parameter.");
        HashMap<QName, String> values = new HashMap<QName, String>();
        values.put(uidParam, "uid-" + UUID.randomUUID().toString());
        for (Node urlTemplate : uidTemplates) {
            Element urlElem = (Element)urlTemplate;
            String mediaType = urlElem.getAttribute("type");
            if (!mediaType.contains("xml")) continue;
            URI uri = OpenSearchTemplateUtils.buildRequestURI(urlElem, values);
            this.request = ClientUtils.buildGetRequest(uri, null, MediaType.valueOf((String)mediaType));
            this.response = this.client.handle(this.request);
            Assert.assertEquals((int)this.response.getStatus(), (int)ClientResponse.Status.NOT_FOUND.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        }
    }

    @Test(description="OGC 12-176r6, Table 6")
    public void getResourceById() {
        List<Node> uidTemplates = OpenSearchTemplateUtils.filterURLTemplatesByParam(this.urlTemplates, UID_PARAM);
        Assert.assertFalse((boolean)uidTemplates.isEmpty(), (String)"No URL templates containing {geo:uid} parameter.");
        HashMap<QName, String> values = new HashMap<QName, String>();
        int randomIndex = ThreadLocalRandom.current().nextInt(this.idList.size());
        String id = this.idList.get(randomIndex);
        values.put(UID_PARAM, URIUtils.getPercentEncodedString(id));
        for (Node urlTemplate : uidTemplates) {
            Element url = (Element)urlTemplate;
            String mediaType = url.getAttribute("type");
            if (!mediaType.startsWith("application/atom+xml")) continue;
            URI uri = OpenSearchTemplateUtils.buildRequestURI(url, values);
            this.request = ClientUtils.buildGetRequest(uri, null, MediaType.valueOf((String)mediaType));
            this.response = this.client.handle(this.request);
            Assert.assertEquals((int)this.response.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
            Document entity = this.getResponseEntityAsDocument(this.response, null);
            String recordPath = "atom:feed/atom:entry";
            String expr = String.format("/%s/dc:identifier = '%s'", recordPath, id);
            ETSAssert.assertXPath(expr, entity, Collections.singletonMap("http://www.w3.org/2005/Atom", "atom"));
            Source source = ClientUtils.getResponseEntityAsSource(this.response, null);
            URL schemaUrl = this.getClass().getResource("/org/opengis/cite/cat30/sch/atom-feed.sch");
            ETSAssert.assertSchematronValid(schemaUrl, source);
        }
    }

    @Test(description="OGC 10-032r8: 9.3,A.3")
    public void invalidBoundingBoxCoords() {
        QName boxParam = new QName("http://a9.com/-/opensearch/extensions/geo/1.0/", "box");
        List<Node> boxTemplates = OpenSearchTemplateUtils.filterURLTemplatesByParam(this.urlTemplates, boxParam);
        Assert.assertFalse((boolean)boxTemplates.isEmpty(), (String)"No URL templates containing {geo:box} parameter.");
        HashMap<QName, String> values = new HashMap<QName, String>();
        values.put(boxParam, "514432,5429689,529130,5451619");
        for (Node urlTemplate : boxTemplates) {
            Element url = (Element)urlTemplate;
            String mediaType = url.getAttribute("type");
            if (!mediaType.contains("xml")) continue;
            URI uri = OpenSearchTemplateUtils.buildRequestURI(url, values);
            this.request = ClientUtils.buildGetRequest(uri, null, MediaType.valueOf((String)mediaType));
            this.response = this.client.handle(this.request);
            Assert.assertEquals((int)this.response.getStatus(), (int)ClientResponse.Status.BAD_REQUEST.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
        }
    }

    @Test(description="Requirements: 022,023; OGC 10-032r8, A.3")
    public void boundingBoxQuery() {
        QName boxParam = new QName("http://a9.com/-/opensearch/extensions/geo/1.0/", "box");
        List<Node> boxTemplates = OpenSearchTemplateUtils.filterURLTemplatesByParam(this.urlTemplates, boxParam);
        Assert.assertFalse((boolean)boxTemplates.isEmpty(), (String)"No URL templates containing {geo:box} parameter.");
        HashMap<QName, String> values = new HashMap<QName, String>();
        Envelope bbox = this.geoExtent;
        try {
            if (!bbox.getCoordinateReferenceSystem().equals(DefaultGeographicCRS.WGS84)) {
                bbox = new GeneralEnvelope(Envelopes.transform((Envelope)bbox, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
            }
        }
        catch (TransformException ex) {
            throw new AssertionError("Failed to create CRS84 box from envelope in source CRS: " + bbox.getCoordinateReferenceSystem().getName(), ex);
        }
        values.put(boxParam, Extents.envelopeToString((Envelope)bbox));
        for (Node urlTemplate : boxTemplates) {
            QName docElem;
            Element url = (Element)urlTemplate;
            String mediaType = url.getAttribute("type");
            if (!mediaType.contains("xml")) continue;
            URI uri = OpenSearchTemplateUtils.buildRequestURI(url, values);
            this.request = ClientUtils.buildGetRequest(uri, null, MediaType.valueOf((String)mediaType));
            this.response = this.client.handle(this.request);
            Assert.assertEquals((int)this.response.getStatus(), (int)ClientResponse.Status.OK.getStatusCode(), (String)ErrorMessage.get("UnexpectedStatus"));
            Document entity = this.getResponseEntityAsDocument(this.response, null);
            ETSAssert.assertEnvelopeIntersectsBoundingBoxes(bbox, new DOMSource(entity));
            if (mediaType.startsWith("application/atom+xml")) {
                Source source = ClientUtils.getResponseEntityAsSource(this.response, null);
                URL schemaUrl = this.getClass().getResource("/org/opengis/cite/cat30/sch/atom-feed.sch");
                ETSAssert.assertSchematronValid(schemaUrl, source);
                continue;
            }
            if (mediaType.startsWith("application/rss+xml")) {
                docElem = new QName("", "rss");
                ETSAssert.assertQualifiedName(entity.getDocumentElement(), docElem);
                continue;
            }
            docElem = new QName("http://www.opengis.net/cat/csw/3.0", "GetRecordsResponse");
            ETSAssert.assertQualifiedName(entity.getDocumentElement(), docElem);
        }
    }
}

