/*
 * Decompiled with CFR 0.152.
 */
package org.opengis.cite.cat30.util;

import java.io.File;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmValue;
import org.opengis.cite.cat30.util.Records;
import org.opengis.cite.cat30.util.TestSuiteLogger;
import org.opengis.cite.cat30.util.XMLUtils;
import org.opengis.cite.geomatics.Extents;
import org.opengis.geometry.Envelope;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DatasetInfo {
    private final File dataFile;
    private Envelope geographicExtent;
    private List<String> recordIdentifiers;
    private List<String> recordTitles;
    private List<String> topics;

    public DatasetInfo(File dataFile) {
        if (!dataFile.isFile()) {
            throw new IllegalArgumentException("Data file does not exist at " + dataFile.getAbsolutePath());
        }
        QName docElemName = XMLUtils.nameOfDocumentElement(new StreamSource(dataFile));
        if (!docElemName.getLocalPart().equals("GetRecordsResponse")) {
            Logger.getLogger(DatasetInfo.class.getName()).log(Level.WARNING, "File does not contain a GetRecords response: {0}", docElemName);
        }
        this.dataFile = dataFile;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    public Envelope getGeographicExtent() {
        if (null == this.geographicExtent) {
            this.geographicExtent = this.calculateTotalExtent(this.dataFile);
        }
        return this.geographicExtent;
    }

    public List<String> getRecordIdentifiers() {
        if (null == this.recordIdentifiers) {
            this.recordIdentifiers = Records.findPropertyValues(this.dataFile, "//dc:identifier");
        }
        return this.recordIdentifiers;
    }

    public List<String> getRecordTitles() {
        if (null == this.recordTitles) {
            this.recordTitles = Records.findPropertyValues(this.dataFile, "//dc:title");
        }
        return this.recordTitles;
    }

    public List<String> getRecordTopics() {
        if (null == this.topics) {
            this.topics = Records.findPropertyValues(this.dataFile, "//dc:subject");
        }
        return this.topics;
    }

    public XdmValue findItems(String xpath, Map<String, String> nsBindings) throws SaxonApiException {
        if (null == nsBindings) {
            nsBindings = new HashMap<String, String>();
            nsBindings.put("http://www.opengis.net/cat/csw/3.0", "csw");
            nsBindings.put("http://www.opengis.net/ows/2.0", "ows");
            nsBindings.put("http://purl.org/dc/elements/1.1/", "dc");
            nsBindings.put("http://purl.org/dc/terms/", "dct");
        }
        XdmValue results = XMLUtils.evaluateXPath2(new StreamSource(this.dataFile), xpath, nsBindings);
        return results;
    }

    Envelope calculateTotalExtent(File file) {
        Envelope extent;
        StreamSource src = new StreamSource(this.dataFile);
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)XMLUtils.evaluateXPath(src, "//csw:Record/ows:BoundingBox[1] | //csw:Record/ows:WGS84BoundingBox[1]", null, XPathConstants.NODESET);
        }
        catch (XPathExpressionException xpe) {
            TestSuiteLogger.log(Level.WARNING, "getBoundingBoxes: ", xpe);
        }
        if (nodeList.getLength() == 0) {
            return null;
        }
        List<Node> boxNodes = XMLUtils.getNodeListAsList(nodeList);
        try {
            extent = Extents.coalesceBoundingBoxes(boxNodes);
        }
        catch (TransformException | FactoryException ex) {
            StringBuilder msg = new StringBuilder("Failed to coalesce bounding boxes. ");
            msg.append(new String(ex.getMessage().getBytes(), StandardCharsets.US_ASCII));
            throw new RuntimeException(msg.toString());
        }
        return extent;
    }
}

